/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class SFTimerStarterTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long flowId = Long.parseLong((String)map.get("flowid"));
        String key = "/isc/iscb/timer_sf/" + requestContext.getAccountId() + "/" + flowId;
        try (DLock lock = DLock.create((String)key).fastMode();){
            lock.lock();
            if (this.hasUnFinishedFlowInst(flowId)) {
                this.saveIgnoredLog(requestContext, flowId);
            } else {
                this.innerStartFlow(flowId);
            }
        }
    }

    private void saveIgnoredLog(RequestContext rc, long flowId) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"isc_sf_proc_inst");
        long procInstId = IDService.get().genLongId();
        obj.set("id", (Object)procInstId);
        obj.set("flow", (Object)flowId);
        obj.set("state", (Object)ProcessState.Ignored.name());
        obj.set("number", (Object)Hash.mur2digital32((Object[])new Object[]{procInstId}));
        obj.set("creator", (Object)rc.getCurrUserId());
        obj.set("modifier", (Object)rc.getCurrUserId());
        obj.set("context", (Object)ResManager.loadKDString((String)"\u7531\u4e8e\u5f53\u524d\u670d\u52a1\u6d41\u7a0b\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u672c\u6b21\u6267\u884c\u8ba1\u5212\u5df2\u5ffd\u7565\u3002", (String)"SFTimerStarterTask_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        Timestamp time = new Timestamp(System.currentTimeMillis());
        obj.set("created_time", (Object)time);
        obj.set("modified_time", (Object)time);
        Flow flow = ServiceFlowParser.getFlow(flowId);
        FlowRuntime runtime = flow.newInstance(String.valueOf(procInstId));
        Map json = runtime.toJson();
        obj.set("context_tag", (Object)Json.toString((Object)json, (boolean)true));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasUnFinishedFlowInst(long flowId) {
        String sql = "SELECT count(*) FROM t_isc_sf_proc_inst WHERE freleased_flow = ? and fstate in (?,?)";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            List<Object> values = Arrays.asList(flowId, "Running", "Created");
            List<Integer> types = Arrays.asList(-5, 12, 12);
            int count = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, values, types));
            boolean bl = count > 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void innerStartFlow(long flowId) {
        try {
            ServiceFlowEngine.createAndStart(flowId, new Object[0]);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("iscb", ResManager.loadKDString((String)"\u670d\u52a1\u7f16\u6392\u5b9a\u65f6\u542f\u52a8\u5f02\u5e38", (String)"SFTimerStarterTask_1", (String)"isc-iscb-platform-core", (Object[])new Object[0])), new Object[0]);
        }
    }
}

