/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.DaemonTaskManager;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.task.MutexTask;
import kd.isc.iscb.platform.core.task.MutexTaskManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.util.data.Heap;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceItem;
import kd.isc.iscb.util.trace.TraceManager;

public class ScheduleManager {
    private static boolean waiting = false;
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"ISC_TASK_SCHEDULE", (int)0, (int)2);
    private static final Log log = LogFactory.getLog(TaskManager.class);
    private static final Heap<Item> queue = new Heap();

    public static void submit(Task task, int seconds) {
        int delay = Math.max(seconds * 1000, 20);
        ScheduleManager.submit(task, System.currentTimeMillis() + (long)delay);
    }

    public static void submit(Task task, RequestContext ctx, int seconds) {
        int delay = Math.max(seconds * 1000, 20);
        ScheduleManager.submit(task, ctx, System.currentTimeMillis() + (long)delay);
    }

    public static void submit(Task task, long scheduledTime) {
        ScheduleManager.submit(task, RequestContext.get(), scheduledTime);
    }

    public static synchronized void submit(Task task, RequestContext ctx, long scheduledTime) {
        if (ctx == null) {
            throw new NullPointerException("ctx is null.");
        }
        if (task == null) {
            throw new NullPointerException("task is null.");
        }
        Item item = new Item(task, scheduledTime, ctx);
        queue.push((Comparable)item);
        if (waiting) {
            ScheduleManager.class.notifyAll();
        } else {
            ScheduleManager.startWaitingThread();
        }
    }

    public static synchronized List<Map<String, Object>> getTaskInfos() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(queue.size() + 1);
        LinkedHashMap<String, Object> env = new LinkedHashMap<String, Object>(8);
        TenantInfo tenant = LicenseCache.getTenant();
        env.put("serverId", NetUtil.getServerId());
        env.put("accountId", tenant.getCurrentAccount().getAccountId());
        env.put("getStartTime", tenant.getStartTime());
        env.put("isMaster", JobEngine.isMaster());
        env.put("masters", JobEngine.getMasters());
        list.add(env);
        RequestContext current = RequestContext.get();
        for (Item item : queue) {
            LinkedHashMap<String, Object> e = new LinkedHashMap<String, Object>(8);
            RequestContext ctx = item.ctx;
            String tenantId = ctx.getTenantId();
            String accountId = ctx.getAccountId();
            String suffix = current.getAccountId().equals(accountId) ? "*" : "";
            e.put("class", item.task.getClass().getName() + suffix);
            e.put("scheduleTime", new Timestamp(item.scheduledTime));
            e.put("tenant", StringUtil.hashMask((String)tenantId, (int)1));
            e.put("account", StringUtil.hashMask((String)accountId, (int)4));
            list.add(e);
        }
        return list;
    }

    private static synchronized void setNoWaiting() {
        waiting = false;
        if (!queue.isEmpty()) {
            ScheduleManager.startWaitingThread();
        }
    }

    private static void startWaitingThread() {
        waiting = true;
        threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (ScheduleManager.hasTask()) {
                        Item i = ScheduleManager.pop();
                        Task task = i.task;
                        if (task instanceof DaemonTask) {
                            DaemonTaskManager.submit((DaemonTask)task, i.ctx);
                            continue;
                        }
                        if (task instanceof LightTask) {
                            LightTaskManager.submit((LightTask)task, i.current, i.ctx);
                            continue;
                        }
                        if (task instanceof MutexTask) {
                            MutexTaskManager.submit((MutexTask)task, i.current, i.ctx);
                            continue;
                        }
                        TaskManager.submit(task, i.current, i.ctx);
                    }
                }
                catch (Throwable e) {
                    log.warn(e);
                }
                finally {
                    ScheduleManager.setNoWaiting();
                }
            }
        });
    }

    private static synchronized boolean hasTask() {
        return !queue.isEmpty();
    }

    private static synchronized Item pop() {
        long timeout;
        long now;
        while ((now = System.currentTimeMillis()) < (timeout = ((Item)queue.top()).scheduledTime)) {
            ScheduleManager.pause(now, timeout);
        }
        return (Item)queue.pop();
    }

    private static synchronized void pause(long now, long timeout) {
        try {
            long delay = timeout - now;
            ScheduleManager.class.wait(delay);
        }
        catch (InterruptedException e) {
            log.warn((Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static class Item
    implements Comparable<Item> {
        private Task task;
        private long scheduledTime;
        private RequestContext ctx;
        private TraceItem current;

        private Item(Task task, long scheduledTime, RequestContext ctx) {
            this.task = task;
            this.scheduledTime = scheduledTime;
            this.ctx = ctx;
            this.current = TraceManager.current();
        }

        @Override
        public int compareTo(Item o) {
            return Long.compare(this.scheduledTime, o.scheduledTime);
        }
    }
}

