/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.task.OutOfTaskQueueException;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.data.RollMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Triple;
import kd.isc.iscb.util.trace.TraceItem;

public class TaskQueue {
    private int maxThreads;
    private int maxThreshold;
    private RollMap<String, SimpleQueue> readyQueues = new RollMap(128);
    private HashMap<String, SimpleQueue> blockedQueues = new HashMap(16);
    private HashMap<String, SimpleQueue> emptyQueues = new HashMap(16);
    private HashMap<String, Triple<TraceItem, Task, RequestContext>> tasks = new HashMap(256);
    private static final ThreadLocal<SimpleQueue> currentQueue = new ThreadLocal();
    private static int TOTAL_ACCOUNTS;
    private static final Log log;

    public TaskQueue(int maxThreads) {
        this.maxThreads = maxThreads = Math.max(maxThreads, 5);
        this.maxThreshold = (int)Math.max(2.0, (double)maxThreads / (Math.log10(TOTAL_ACCOUNTS * 5 - 4) + 1.0));
    }

    public boolean containsTask(String taskId) {
        return false;
    }

    public void in(RequestContext ctx, Triple<TraceItem, Task, RequestContext> t) {
        if (this.tasks.size() > this.getMaxQueueSize()) {
            throw new OutOfTaskQueueException(String.format(ResManager.loadKDString((String)"ISC\u4efb\u52a1\u961f\u5217\u7684\u957f\u5ea6\u5df2\u8d85\u8fc7\u6700\u5927\u914d\u7f6e\u503c\uff1a%s,\u8bf7\u68c0\u67e5\u914d\u7f6e\u4e0d\u5408\u7406\u7684\u4efb\u52a1\u5e76\u5c3d\u5feb\u4fee\u590d\u3002", (String)"TaskQueue_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.getMaxQueueSize()));
        }
        if (this.tasks.putIfAbsent(((Task)t.getB()).getId(), t) == null) {
            String accountId = ctx.getAccountId();
            SimpleQueue q = this.getQueue(accountId);
            this.enqueue(t, q);
            this.tryMoveToReady(q);
        }
    }

    private int getMaxQueueSize() {
        String s = System.getProperty("ISC_TASK_QUEUE_MAX_SIZE");
        if (s == null) {
            return 200000;
        }
        return D.i((Object)s);
    }

    public int tasksBefore(String taskId) {
        if (!this.tasks.containsKey(taskId)) {
            return -1;
        }
        SimpleQueue q = this.getQueue(RequestContext.get().getAccountId());
        int count = 0;
        for (Triple t : q.tasks) {
            if (taskId.equals(((Task)t.getB()).getId())) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    private SimpleQueue getQueue(String accountId) {
        SimpleQueue q = this.blockedQueues.get(accountId);
        if (q != null) {
            return q;
        }
        q = (SimpleQueue)this.readyQueues.get((Object)accountId);
        if (q != null) {
            return q;
        }
        return new SimpleQueue(accountId);
    }

    public Triple<TraceItem, Task, RequestContext> out() {
        Map.Entry e = this.readyQueues.first();
        if (e == null) {
            log.warn("\u5c31\u7eea\u961f\u5217\u7ec4\u662f\u7a7a\u7684\u3002");
            return null;
        }
        SimpleQueue q = (SimpleQueue)e.getValue();
        if (q.tasks.isEmpty()) {
            return this.handleUnexpectedEmptyQueue(q);
        }
        return this.pollFirst(q);
    }

    private Triple<TraceItem, Task, RequestContext> pollFirst(SimpleQueue q) {
        currentQueue.set(q);
        Triple<TraceItem, Task, RequestContext> t = this.dequeue(q);
        ++q.runningCount;
        this.tasks.remove(((Task)t.getB()).getId());
        this.tryMoveToBlocked(q);
        return t;
    }

    private Triple<TraceItem, Task, RequestContext> dequeue(SimpleQueue q) {
        Triple t = (Triple)q.tasks.removeFirst();
        if (((Task)t.getB()).isJob()) {
            --q.jobCount;
        }
        return t;
    }

    private void enqueue(Triple<TraceItem, Task, RequestContext> t, SimpleQueue q) {
        q.tasks.addLast(t);
        if (((Task)t.getB()).isJob()) {
            ++q.jobCount;
        }
    }

    private Triple<TraceItem, Task, RequestContext> handleUnexpectedEmptyQueue(SimpleQueue q) {
        log.warn("\u7a7a\u961f\u5217\u6df7\u5165\u4e86\u5c31\u7eea\u961f\u5217\u7ec4\u4e2d\uff0c\u961f\u5217\u662f\uff1a" + q.account);
        this.tryMoveToBlocked(q);
        return null;
    }

    public void done() {
        SimpleQueue q = currentQueue.get();
        if (q != null) {
            --q.runningCount;
            this.tryMoveToReady(q);
        } else {
            log.warn("\u5f53\u524d\u961f\u5217\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u56de\u6536\u3002");
        }
    }

    public boolean hasReadyTasks() {
        return !this.readyQueues.isEmpty();
    }

    public Set<String> getBusyAccounts() {
        HashSet<String> accounts = new HashSet<String>(16);
        for (SimpleQueue q : this.readyQueues.values()) {
            this.collectBusyAccount(accounts, q);
        }
        for (SimpleQueue q : this.blockedQueues.values()) {
            this.collectBusyAccount(accounts, q);
        }
        return accounts;
    }

    private void collectBusyAccount(HashSet<String> accounts, SimpleQueue q) {
        int threshold = this.getThreshold();
        if (q.jobCount > threshold) {
            accounts.add(q.account);
        }
    }

    public int size() {
        return this.tasks.size();
    }

    private void tryMoveToBlocked(SimpleQueue q) {
        if (!q.isBlocked && this.shouldBeBlocked(q)) {
            q.isBlocked = true;
            this.readyQueues.remove((Object)q.account);
            this.blockedQueues.put(q.account, q);
        }
        if (q.tasks.isEmpty()) {
            this.emptyQueues.put(q.account, q);
        }
    }

    private void tryMoveToReady(SimpleQueue q) {
        if (q.isBlocked && !this.shouldBeBlocked(q)) {
            q.isBlocked = false;
            this.readyQueues.put((Object)q.account, (Object)q);
            this.blockedQueues.remove(q.account);
        }
        if (!q.tasks.isEmpty()) {
            this.emptyQueues.remove(q.account);
        }
    }

    private boolean shouldBeBlocked(SimpleQueue q) {
        return q.tasks.isEmpty() || q.runningCount >= this.getThreshold();
    }

    private int getThreshold() {
        int queueCount = this.blockedQueues.size() + this.readyQueues.size() - this.emptyQueues.size();
        int threshold = this.maxThreads / Math.max(queueCount + 1, 1);
        return Math.min(this.maxThreshold, Math.max(1, threshold));
    }

    static {
        try {
            TOTAL_ACCOUNTS = Math.max(1, AccountUtils.getAllAccountsOfCurrentEnv().size());
        }
        catch (Throwable e) {
            TOTAL_ACCOUNTS = 10;
        }
        log = LogFactory.getLog(TaskQueue.class);
    }

    private static class SimpleQueue {
        private String account;
        private int jobCount = 0;
        private boolean isBlocked = true;
        private int runningCount = 0;
        private LinkedList<Triple<TraceItem, Task, RequestContext>> tasks = new LinkedList();

        private SimpleQueue(String account) {
            this.account = account;
        }
    }
}

