/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.Const;
import kd.isc.iscb.platform.core.connector.apic.doc.meta.MetaApiDocBuilder;
import kd.isc.iscb.util.dt.D;

public final class ApiToXmlUtil
implements Const {
    private static final String[] inputList = new String[]{"mapping_src_column", "params_name", "prop_name", "input_field"};

    public static boolean isEntries(String type) {
        return type != null && type.startsWith("ENTRIES");
    }

    public static String formatDesc(String str) {
        if (str == null) {
            return null;
        }
        int k = str.lastIndexOf(46);
        if (k > -1) {
            return str.substring(k + 1);
        }
        return str;
    }

    public static String formatName(DynamicObject meta, String str) {
        if (str == null) {
            return null;
        }
        int k = str.lastIndexOf(46);
        if (k > -1 && meta != null) {
            String type = ApiToXmlUtil.getProperty(meta, str.substring(0, k), "data_type");
            if (!ApiToXmlUtil.isEntries(type) && !ApiToXmlUtil.isRef(type)) {
                return str;
            }
            return str.substring(k + 1);
        }
        return str.substring(k + 1);
    }

    public static String getProperty(DynamicObject meta, String name, String property) {
        int pos = name.indexOf(46);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("prop_entryentity");
        if (pos < 0) {
            for (DynamicObject prop : properties) {
                if (!prop.get("prop_name").equals(name)) continue;
                return prop.getString(property);
            }
        } else {
            String entry = name.substring(0, pos);
            String entryProp = name.substring(pos + 1);
            for (DynamicObject prop : properties) {
                if (!prop.get("prop_name").equals(entry)) continue;
                String dataSchema = prop.getString("data_schema");
                DynamicObject dc = JsonSampleUtil.findMetaByDataSchema(meta, dataSchema);
                return ApiToXmlUtil.getProperty(dc, entryProp, property);
            }
            return entry;
        }
        return null;
    }

    public static boolean hasNoMapping(DynamicObject item, String field) {
        if (D.s((Object)field) == null) {
            return true;
        }
        return D.s((Object)item.getString("mapping_src_column")) == null && D.s((Object)item.getString("fixed_value")) == null;
    }

    public static boolean isInput(String filed) {
        for (String s : inputList) {
            if (!filed.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static String getOutputJsonExample(DynamicObject api, DynamicObject meta) {
        String jsonStr = "{\n}";
        DynamicObjectCollection outputs = api.getDynamicObjectCollection("outputs");
        String operation = api.getString("operation");
        if ("QUERY".equals(operation) || "SQL_EXECUTE_R".equals(operation) || "EXECUTE".equals(operation)) {
            if (outputs.isEmpty()) {
                if (!"EXECUTE".equals(operation)) {
                    jsonStr = JsonSampleUtil.toJsonString(meta.getLong("id")).replace("\t", "    ");
                }
            } else {
                JSONObject outData;
                HashMap<String, Object> requires = new HashMap<String, Object>();
                MetaApiDocBuilder.existInputsOrOutputs(outputs, requires, "output_data_type", "output_field");
                if ("EXECUTE".equals(operation)) {
                    JSONObject data = JsonSampleUtil.toJSONObjectResult(meta.getLong("id"), requires);
                    requires.forEach((k, v) -> {
                        if (!data.containsKey(k)) {
                            data.put(k, v);
                        }
                    });
                    outData = data;
                } else {
                    JSONObject data = JsonSampleUtil.toJSONObject(meta.getLong("id"), requires);
                    requires.forEach((k, v) -> {
                        if (!data.containsKey(k)) {
                            data.put(k, v);
                        }
                    });
                    outData = data;
                }
                jsonStr = JSON.toJSONString((Object)outData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replace("\t", "    ");
            }
        } else {
            jsonStr = "{\n    \"id\": null,\n    \"type\": \"\"\n}";
        }
        return jsonStr;
    }

    public static boolean isEnum(String type) {
        return type != null && "ENUM".equals(type);
    }

    public static boolean isRef(String type) {
        return type != null && type.startsWith("REF");
    }

    public static List<String> getAlias(DynamicObject schema) {
        ArrayList<String> alias = new ArrayList<String>(2);
        DynamicObjectCollection entry = schema.getDynamicObjectCollection("relation_mapping");
        for (DynamicObject it : entry) {
            alias.add(it.getString("relation_alias"));
        }
        return alias;
    }

    public static DynamicObject getMetaByAlias(DynamicObject schema, String alias) {
        if (alias == null) {
            return null;
        }
        DynamicObjectCollection entry = schema.getDynamicObjectCollection("relation_mapping");
        for (DynamicObject it : entry) {
            if (!alias.equals(it.getString("relation_alias"))) continue;
            return BusinessDataServiceHelper.loadSingle((Object)it.getDynamicObject("data_table").getPkValue(), (String)"isc_metadata_schema");
        }
        return null;
    }

    public static String translateType(String type) {
        switch (type) {
            case "List(nclob)": 
            case "nclob": 
            case "string": {
                return ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"ApiToXmlUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "int": 
            case "integer": {
                return ResManager.loadKDString((String)"\u6574\u6570", (String)"ApiToXmlUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "decimal": {
                return ResManager.loadKDString((String)"\u5c0f\u6570", (String)"ApiToXmlUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "double": {
                return ResManager.loadKDString((String)"\u6d6e\u70b9\u6570", (String)"ApiToXmlUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "datetime": {
                return ResManager.loadKDString((String)"\u65e5\u671f/\u65f6\u95f4", (String)"ApiToXmlUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "long": {
                return ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"ApiToXmlUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "boolean": {
                return ResManager.loadKDString((String)"\u662f/\u5426", (String)"ApiToXmlUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "ENUM": {
                return ResManager.loadKDString((String)"\u679a\u4e3e", (String)"ApiToXmlUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "variant": 
            case "STRUCT": {
                return ResManager.loadKDString((String)"\u7ed3\u6784", (String)"ApiToXmlUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "List(variant)": {
                return ResManager.loadKDString((String)"\u5217\u8868", (String)"ApiToXmlUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "ENTRIES": {
                return ResManager.loadKDString((String)"\u5206\u5f55", (String)"ApiToXmlUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            case "ARRAY": {
                return ResManager.loadKDString((String)"\u6570\u7ec4", (String)"ApiToXmlUtil_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
        }
        return type;
    }

    public static Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("id", 1);
        return map;
    }

    public static boolean isVariant(String dataType) {
        return dataType != null && dataType.contains("variant");
    }

    public static String getTabChar(int deep, int index, int len) {
        if (deep == 0) {
            return "";
        }
        if (index < len - 1) {
            return "\u251c ";
        }
        return "\u2514 ";
    }

    public static String getPrefix(int deep) {
        StringBuilder s = new StringBuilder();
        while (deep > 1) {
            s.append('\u3000');
            --deep;
        }
        return s.toString();
    }

    public static Map<String, Object> existPuts(DynamicObject meta, String field, List<DynamicObject> supplier) {
        HashMap<String, Object> requires = new HashMap<String, Object>(8);
        HashMap<String, Set<String>> nodeMap = new HashMap<String, Set<String>>(32);
        for (DynamicObject it2 : supplier) {
            String inputField = it2.getString(field);
            if (!inputField.contains(".")) {
                requires.put(inputField, 1);
                continue;
            }
            String key = inputField.substring(0, inputField.lastIndexOf(46));
            if (meta != null) {
                String type = ApiToXmlUtil.getProperty(meta, key, "data_type");
                if (!ApiToXmlUtil.isEntries(type) && !ApiToXmlUtil.isRef(type)) {
                    requires.put(inputField, 1);
                    continue;
                }
                ApiToXmlUtil.setNodeMap(nodeMap, inputField);
                continue;
            }
            ApiToXmlUtil.setNodeMap(nodeMap, inputField);
        }
        Map<String, Set<String>> firstEntitySet = MetaApiDocBuilder.getEntityChild(null, nodeMap);
        for (Map.Entry<String, Set<String>> entry : firstEntitySet.entrySet()) {
            Map<String, Set<String>> childMap = MetaApiDocBuilder.getEntityChild(entry.getKey(), nodeMap);
            Map<String, Object> value = MetaApiDocBuilder.getNode(entry.getKey(), childMap, nodeMap);
            value.putAll(entry.getValue().stream().filter(it -> !value.containsKey(it)).collect(Collectors.toMap(it -> it, it -> 1)));
            requires.put(entry.getKey(), value);
        }
        return requires;
    }

    private static void setNodeMap(Map<String, Set<String>> nodeMap, String inputField) {
        String key = inputField.substring(0, inputField.lastIndexOf(46));
        String value = inputField.substring(inputField.lastIndexOf(46) + 1);
        Set<String> vSet = nodeMap.get(key);
        if (vSet == null) {
            vSet = new HashSet<String>();
        }
        vSet.add(value);
        nodeMap.put(key, vSet);
    }

    public static Font getFont(int size) {
        String property = System.getProperty("ISC_FONT", "SimSun");
        return new Font(property, 0, size);
    }
}

