/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;

public class CollectionUtils {
    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collecton) {
        return collecton == null || collecton.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static List toList(Object data) {
        if (data == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570data\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u4e3alist\u5bf9\u8c61!", (String)"CollectionUtils_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (data instanceof List) {
            return (List)data;
        }
        if (data instanceof Collection) {
            return new ArrayList((Collection)data);
        }
        if (data instanceof Object[]) {
            return Arrays.asList((Object[])data);
        }
        return Collections.singletonList(data);
    }

    public static Set toSet(Object data) {
        if (data == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570data\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8f6c\u4e3aSet\u5bf9\u8c61!", (String)"CollectionUtils_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (data instanceof Set) {
            return (Set)data;
        }
        if (data instanceof Collection) {
            return new HashSet((Collection)data);
        }
        if (data instanceof Object[]) {
            return new HashSet<Object>(Arrays.asList((Object[])data));
        }
        return Collections.singleton(data);
    }

    public static String toString(Object data) {
        return CollectionUtils.toString(data, Integer.MAX_VALUE);
    }

    public static String toString(Object data, int limit) {
        if (data == null) {
            return "null";
        }
        if (data instanceof List) {
            List list = (List)data;
            Object[] b = CollectionUtils.copyArray(list.toArray(), limit);
            return Arrays.toString(b);
        }
        if (data instanceof Object[]) {
            Object[] b = CollectionUtils.copyArray((Object[])data, limit);
            return Arrays.toString(b);
        }
        if (data instanceof Set) {
            Set set = (Set)data;
            Object[] b = CollectionUtils.copyArray(set.toArray(), limit);
            return Arrays.toString(b);
        }
        if (data instanceof Map) {
            return JSON.toJSONString((Object)data);
        }
        return data.toString();
    }

    public static Object[] copyArray(Object[] a, int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u9650\u5236\u6570\u503c\u4e0d\u80fd\u4e3a\u8d1f\u503c\uff1a%s", (String)"CollectionUtils_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), limit));
        }
        if (limit >= a.length) {
            return a;
        }
        int length = Math.min(limit, a.length);
        Object[] b = new Object[length];
        System.arraycopy(a, 0, b, 0, length);
        return b;
    }

    public static Map<Object, Object> toMap(Object ... args) {
        if (args == null || args.length == 0) {
            return Collections.emptyMap();
        }
        int length = args.length;
        if (length % 2 != 0) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"Map\u6784\u9020\u53c2\u6570\u5e94\u4e3a\u5076\u6570\u4e2a\uff0c\u5f53\u524d\u4e2a\u6570\u4e3a:%s", (String)"CollectionUtils_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), length));
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(length);
        for (int i = 0; i < args.length; i += 2) {
            Object key = args[i];
            Object value = args[i + 1];
            map.put(key, value);
        }
        return map;
    }
}

