/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.lang.Lang;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.trace.util.TraceIdUtil;
import kd.isc.iscb.platform.core.connector.self.ProxyUserUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class ContextUtil {
    public static RequestContext createRequestContext(String account, String tenant) {
        String userId = "1";
        String userName = "administrator";
        return ContextUtil.createRequestContext(account, tenant, userId, userName);
    }

    public static RequestContext createRequestContext(String account, String tenant, String userId, String userName) {
        RequestContext rc = RequestContext.create((boolean)false);
        String traceId = TraceIdUtil.createTraceIdString();
        rc.setTraceId(traceId);
        rc.setAccountId(account);
        rc.setTenantId(tenant);
        rc.setTenantCode(tenant);
        rc.setClient(ResManager.loadKDString((String)"\u96c6\u6210\u4e91", (String)"ContextUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        rc.setUserId(userId);
        rc.setUserName(userName);
        rc.setLang(Lang.defaultLang());
        return rc;
    }

    public static boolean isCurrentContext(String account, String tenant) {
        RequestContext ctx = RequestContext.get();
        return ctx.getAccountId().equals(account) && ctx.getTenantId().equals(tenant);
    }

    public static RequestContext restoreAndGetContext(RequestContext current, String proxy_user) {
        RequestContext new_rc = null;
        if (!StringUtil.isEmpty((String)proxy_user)) {
            new_rc = ProxyUserUtil.createRequestContext(current, proxy_user);
            RequestContextCreator.restoreForMQ((RequestContext)new_rc);
        }
        return new_rc;
    }

    public static long newId() {
        return IDService.get().genLongId();
    }

    public static String getTenantProperty(String key) {
        String tenantId = RequestContext.get().getTenantId();
        return SystemPropertyUtils.getProptyByTenant((String)key, (String)tenantId);
    }
}

