/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.core.NativeFunction;

public class CustomFunctionApplier {
    public static Script compileWithCustomFunctions(String srcScript, DynamicObject obj, String entryName) {
        DynamicObjectCollection functionEntry = obj.getDynamicObjectCollection(entryName);
        if (functionEntry.isEmpty()) {
            return Script.compile((String)srcScript);
        }
        HashMap<String, CustomFunction> ctx = new HashMap<String, CustomFunction>();
        for (DynamicObject entry : functionEntry) {
            CustomFunction customFunction = CustomFunctionApplier.buildCustomFunction(entry);
            if (customFunction == null) continue;
            ctx.put(customFunction.name(), customFunction);
        }
        return Script.compile((String)srcScript, ctx);
    }

    public static Script compileWithCustomFunctions(String srcScript, Object pkValue, String entityName, String entryName) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)entityName, (String)"id,custom_function,function_number");
        return CustomFunctionApplier.compileWithCustomFunctions(srcScript, obj, entryName);
    }

    private static CustomFunction buildCustomFunction(DynamicObject dynamicObject) {
        String fnName = dynamicObject.getString("function_number");
        Object fnId = dynamicObject.get("custom_function_id");
        if (fnName != null && fnId != null) {
            DynamicObject functionObj = BusinessDataServiceHelper.loadSingle((Object)fnId, (String)"isc_custom_function", (String)"script_jst_tag,function_name,result_name,function_type,result_type");
            return new CustomFunction(functionObj.getString("script_jst_tag"), fnName, CustomFunctionApplier.getEntryFields(functionObj, "function_entries", "function_name", "function_type"), CustomFunctionApplier.getEntryFields(functionObj, "result_entries", "result_name", "result_type"));
        }
        return null;
    }

    private static LinkedHashMap<String, String> getEntryFields(DynamicObject obj, String entryName, String field, String type) {
        DynamicObjectCollection collection = obj.getDynamicObjectCollection(entryName);
        LinkedHashMap<String, String> re = new LinkedHashMap<String, String>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            re.put(dynamicObject.getString(field), dynamicObject.getString(type));
        }
        return re;
    }

    public static Object transDataType(Object param_type, Object param_value) {
        if ("string".equals(param_type)) {
            return D.s((Object)param_value);
        }
        if ("integer".equals(param_type)) {
            return D.i((Object)param_value);
        }
        if ("decimal".equals(param_type)) {
            return D.n((Object)param_value);
        }
        if ("datetime".equals(param_type)) {
            return D.t((Object)param_value);
        }
        if ("boolean".equals(param_type)) {
            return D.x((Object)param_value);
        }
        return param_value;
    }

    static {
        Functions.init();
    }

    static class CustomFunction
    implements NativeFunction {
        private Script script;
        private String functionName;
        private LinkedHashMap<String, String> paramMap;
        private LinkedHashMap<String, String> resultMap;

        private CustomFunction(String script, String functionName, LinkedHashMap<String, String> paramMap, LinkedHashMap<String, String> resultMap) {
            this.script = Script.compile((String)script);
            this.functionName = functionName;
            this.paramMap = paramMap;
            this.resultMap = resultMap;
        }

        public Object call(ScriptContext ctx, Object[] args) {
            Map<String, Object> params = this.buildParams(args);
            this.script.eval(params);
            return this.getResult(params);
        }

        private Map<String, Object> buildParams(Object[] args) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Iterator<Map.Entry<String, String>> it = this.paramMap.entrySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                if (i >= args.length) continue;
                params.put(entry.getKey(), CustomFunctionApplier.transDataType(entry.getValue(), args[i++]));
            }
            return params;
        }

        private Object getResult(Map<String, Object> params) {
            switch (this.resultMap.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    Object re = null;
                    for (Map.Entry<String, String> entry : this.resultMap.entrySet()) {
                        re = CustomFunctionApplier.transDataType(entry.getValue(), params.get(entry.getKey()));
                    }
                    return re;
                }
            }
            ArrayList<Object> re = new ArrayList<Object>(this.resultMap.size());
            for (Map.Entry<String, String> entry : this.resultMap.entrySet()) {
                re.add(CustomFunctionApplier.transDataType(entry.getValue(), params.get(entry.getKey())));
            }
            return re;
        }

        public String name() {
            return this.functionName;
        }
    }
}

