/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.connector.notice.LinkPropertyEnum;
import kd.isc.iscb.platform.core.constant.LicenseType;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.MessageNoticeUtil;
import kd.isc.iscb.platform.core.util.MessageSender;
import kd.isc.iscb.platform.core.util.SendMsgUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class DblinkMessageUtil {
    private static final IAppCache cache = AppCache.get((String)"ISCB_NF");
    private static final long HOUR = 3600000L;
    public static final String ERROR_INFO = "error_info";
    public static final String ERROR_MESSAGE = "error_message";
    private static final Log log = LogFactory.getLog(MessageSender.class);

    private static void checkAndSendMes(DynamicObject dblink, Throwable errorInfo) {
        try {
            DynamicObjectCollection noticeIds = DblinkMessageUtil.getNoticeId(dblink);
            for (DynamicObject noticeId : noticeIds) {
                String id = noticeId.getString("id");
                DynamicObject notice = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_link_notification");
                long lastNoticeTime = D.l((Object)cache.get(id, Long.class));
                if (!DblinkMessageUtil.isAllowedToSend(D.l((Object)lastNoticeTime), dblink)) continue;
                dblink.set("state", (Object)"F");
                DblinkMessageUtil.sendMessage(notice, dblink, errorInfo);
                DblinkMessageUtil.updateLastNoticeTime(id);
            }
        }
        catch (Exception e) {
            log.warn("\u8fde\u63a5\u901a\u77e5\u914d\u7f6e\u5931\u8d25" + e);
        }
    }

    public static void checkAndSendMessage(DynamicObject dblink) {
        DblinkMessageUtil.checkAndSendMes(dblink, null);
    }

    public static void checkAndSendMessage(DynamicObject dblink, Throwable errorInfo) {
        DblinkMessageUtil.checkAndSendMes(dblink, errorInfo);
    }

    private static DynamicObjectCollection getNoticeId(DynamicObject dblink) {
        QFilter qFilter = new QFilter("dblink_id", "=", dblink.get("id"));
        qFilter.and("state", "=", (Object)"1");
        return QueryServiceHelper.query((String)"isc_link_notification", (String)"id", (QFilter[])new QFilter[]{qFilter});
    }

    public static void enable(String noticeId) {
        cache.put(noticeId, (Object)0L);
    }

    public static void disable(String noticeId) {
        cache.remove(noticeId);
    }

    private static void updateLastNoticeTime(String id) {
        cache.put(id, (Object)System.currentTimeMillis());
    }

    private static boolean isAllowedToSend(long lastNoticeTime, DynamicObject dblink) {
        boolean b;
        String state = dblink.getString("state");
        if (CommonUtil.isEmpty(state) || "S".equals(state)) {
            log.warn("\u4e0d\u6ee1\u8db3\u53d1\u9001\u6761\u4ef6\uff0c\u72b6\u6001\u662f[" + state + ']');
            return true;
        }
        long now = System.currentTimeMillis();
        boolean bl = b = Math.abs(now - lastNoticeTime) >= 3600000L;
        if (b) {
            log.warn("\u8fde\u63a5\u914d\u7f6e" + dblink.get("number") + "\u5373\u5c06\u53d1\u9001\u901a\u77e5");
        } else {
            log.warn("\u4e0d\u6ee1\u8db3\u53d1\u9001\u6761\u4ef6,\u5f53\u524d\u65f6\u95f4[" + now + "],\u4e0a\u6b21\u901a\u77e5\u65f6\u95f4[" + lastNoticeTime + ']');
        }
        return b;
    }

    private static void sendMessage(DynamicObject notice, DynamicObject dblink, Throwable errorInfo) {
        String outsidePerson;
        List<String> properties = DblinkMessageUtil.getSetProperties();
        String content = DblinkMessageUtil.getSmartStrContent(notice, dblink, properties, errorInfo);
        String person = notice.getString("person");
        if (!StringUtil.isEmpty((String)person)) {
            MessageNoticeUtil.sendCosmicMessage(person, content, notice);
        }
        if (!StringUtil.isEmpty((String)(outsidePerson = notice.getString("outsideperson")))) {
            SendMsgUtil.sendShortMesagge(outsidePerson, content);
        }
    }

    private static String getDefaultContent() {
        return ResManager.loadKDString((String)"#{name} :#{number}\uff0c\u8fde\u63a5\u72b6\u6001\uff1a#{state}\uff1b\u670d\u52a1\u5668IP\uff1a#{server_ip}, \u7aef\u53e3\uff1a#{server_port}, \u8bb8\u53ef\u72b6\u6001#{license_info}\u3002", (String)"DblinkMessageUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    private static String getSmartStrContent(DynamicObject notice, DynamicObject dblink, List<String> properties, Throwable err) {
        String msg = StringUtils.isEmpty((String)notice.getString("msg_content")) ? DblinkMessageUtil.getDefaultContent() : notice.getString("msg_content");
        String scriptStr = "$$(msg)";
        Map<String, Object> data = DblinkMessageUtil.getDataMap(dblink, properties);
        data.put("msg", msg);
        data.put(ERROR_INFO, StringUtil.toString((Throwable)err));
        data.put(ERROR_MESSAGE, StringUtil.getCascadeMessage((Throwable)err));
        Script script = Script.compile((String)scriptStr);
        return (String)script.eval(data);
    }

    private static Map<String, Object> getDataMap(DynamicObject dynamicObject, List<String> properties) {
        HashMap<String, Object> data = new HashMap<String, Object>(properties.size());
        for (String property : properties) {
            data.put(property, DblinkMessageUtil.getProperty(dynamicObject, property));
        }
        return data;
    }

    public static String getProperty(DynamicObject dblink, String propertyName) {
        if ("creator".equals(propertyName) || "modifier".equals(propertyName)) {
            return DblinkMessageUtil.getUserName(dblink, propertyName);
        }
        if ("createtime".equals(propertyName) || "modifytime".equals(propertyName)) {
            return String.valueOf(dblink.getDate(propertyName));
        }
        if ("state".equals(propertyName)) {
            return "F".equals(dblink.getString(propertyName)) ? ResManager.loadKDString((String)"\u5f02\u5e38", (String)"DblinkMessageUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6b63\u5e38", (String)"DblinkMessageUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        if ("license_info".equals(propertyName)) {
            return DblinkMessageUtil.getLicenseInfo(dblink, propertyName);
        }
        if ("database_type".equals(propertyName)) {
            return DblinkMessageUtil.getLinkType(dblink, propertyName);
        }
        return dblink.getString(propertyName);
    }

    public static String getUserName(DynamicObject dblink, String propertyName) {
        DynamicObject user = dblink.getDynamicObject(propertyName);
        if (user != null) {
            return user.getString("name");
        }
        return null;
    }

    public static String getLinkType(DynamicObject dblink, String propertyName) {
        String prop = dblink.getString(propertyName);
        QFilter qFilter = new QFilter("number", "=", (Object)prop);
        DynamicObject typeName = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"name", (QFilter[])new QFilter[]{qFilter});
        if (typeName != null) {
            return typeName.getString("name");
        }
        return prop;
    }

    public static String getLicenseInfo(DynamicObject dblink, String propertyName) {
        String prop = dblink.getString(propertyName);
        for (LicenseType licenseType : LicenseType.values()) {
            if (!String.valueOf((Object)licenseType).equals(prop)) continue;
            return licenseType.getDesc();
        }
        return prop;
    }

    private static List<String> getSetProperties() {
        ArrayList<String> properties = new ArrayList<String>(LinkPropertyEnum.values().length);
        for (LinkPropertyEnum property : LinkPropertyEnum.values()) {
            properties.add(String.valueOf((Object)property));
        }
        return properties;
    }
}

