/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.self.RetrieveData;
import kd.isc.iscb.platform.core.util.PropSetterFactory;
import kd.isc.iscb.platform.core.util.setter.Setter;
import kd.isc.iscb.util.except.IscBizException;

public final class DynamicObjectUtil {
    public static DynamicObject map2Object(String entity, Map<String, Object> data) {
        MainEntityType parentEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicObject obj = null;
        if (data.get("id") != null && DynamicObjectUtil.inDb(data.get("id"), entity)) {
            obj = BusinessDataServiceHelper.loadSingle((Object)data.get("id"), (String)entity);
        }
        if (obj == null) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)entity);
        }
        return DynamicObjectUtil.setDynamicObjectValues(obj, parentEntityType.getProperties(), data);
    }

    public static boolean inDb(Object id, String entityName) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Object newVal = RetrieveData.cast((EntityType)entityType, "id", id);
        QFilter qFilter = new QFilter("id", "=", newVal);
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject setDynamicObjectValues(DynamicObject obj, DataEntityPropertyCollection propertyCollection, Map<String, Object> map) {
        for (IDataEntityProperty property : propertyCollection) {
            String propName = property.getName();
            if (!map.containsKey(propName)) continue;
            Object val = map.get(propName);
            Setter setter = PropSetterFactory.createSetter(property);
            try {
                setter.setObjValue(obj, propName, val, map);
            }
            catch (Exception e) {
                StringBuilder str = new StringBuilder();
                str.append(String.format(ResManager.loadKDString((String)"\u7ed9\u5b57\u6bb5%1$s\u8d4b\u503c%2$s\u51fa\u9519\uff0c\u539f\u56e0\uff1a%3$s", (String)"DynamicObjectUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), propName, val, e.getMessage()));
                throw new IscBizException(str.toString(), (Throwable)e);
            }
        }
        return obj;
    }

    public static Map<String, Object> object2Map(DynamicObject dynamicObject, Map<String, Object> requires) {
        if (null == requires || requires.isEmpty()) {
            return DynamicObjectUtil.object2Map(dynamicObject);
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (dynamicObject != null) {
            objectMap.put("$id", dynamicObject.getPkValue());
            objectMap.put("$pk", "id");
            DataEntityPropertyCollection dynamicObjects = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty property : dynamicObjects) {
                String name = property.getName();
                if (!requires.containsKey(name) || "multilanguagetext".equals(name)) continue;
                Setter setter = PropSetterFactory.createSetter(property);
                try {
                    setter.setMapValue(objectMap, requires, name, dynamicObject);
                }
                catch (Exception e) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7ed9map\u5b57\u6bb5%s\u8d4b\u503c\u51fa\u9519!", (String)"DynamicObjectUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name), (Throwable)e);
                }
            }
        }
        return objectMap;
    }

    public static List<Map<String, Object>> objectCollection2List(DynamicObjectCollection collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> mappings = new ArrayList<Map<String, Object>>(collection.size());
        for (DynamicObject o : collection) {
            mappings.add(DynamicObjectUtil.object2Map(o));
        }
        return mappings;
    }

    public static Map<String, Object> object2Map(DynamicObject o) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (o != null) {
            objectMap.put("$id", o.getPkValue());
            objectMap.put("$pk", "id");
            DataEntityPropertyCollection dynamicObjects = o.getDataEntityType().getProperties();
            for (IDataEntityProperty property : dynamicObjects) {
                String name = property.getName();
                if ("multilanguagetext".equals(name)) continue;
                Setter setter = PropSetterFactory.createSetter(property);
                try {
                    setter.setMapValue(objectMap, null, name, o);
                }
                catch (Exception e) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7ed9map\u5b57\u6bb5%s\u8d4b\u503c\u51fa\u9519!", (String)"DynamicObjectUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name), (Throwable)e);
                }
            }
        }
        return objectMap;
    }
}

