/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.list.ListView;
import kd.isc.iscb.platform.core.dts.ExportDynamicObject;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.platform.core.util.ZipUtils;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;
import org.apache.http.client.utils.DateUtils;

public class ExportAndImportFormUtil {
    private static Log logger = LogFactory.getLog(ExportAndImportFormUtil.class);

    public static void export(IFormView view, DynamicObject[] dObjects) {
        ExportAndImportFormUtil.export(view, dObjects, true);
    }

    public static void export(IFormView view, DynamicObject[] dObjects, boolean exportDependencies) {
        if (CollectionUtils.isEmpty(dObjects)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ExportAndImportFormUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Integer.valueOf(1500));
            return;
        }
        String fileName = ExportAndImportFormUtil.generateFileName(dObjects) + ".dts";
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            ExportDynamicObject.export((OutputStream)output, dObjects, exportDependencies);
            byte[] bytes = output.toByteArray();
            try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)input, 1800);
                if (view instanceof ListView) {
                    FileUtil.addDownloadPermission(((ListView)view).getBillFormId(), urls, view.getFormShowParameter().getServiceAppId());
                } else {
                    FileUtil.addDownloadPermission(view.getEntityId(), urls, view.getFormShowParameter().getServiceAppId());
                }
                view.openUrl(urls);
            }
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ExportAndImportFormUtil_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ExportAndImportFormUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Deprecated
    public static void exportZip(IFormView view, DynamicObject[] dObjects) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u8bf7\u8c03\u7528\u5f02\u6b65\u5bfc\u51fa\u63a5\u53e3asyncExportZip!", (String)"ExportAndImportFormUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public static synchronized void asyncExportZip(String pageId, DynamicObject[] objects) {
        String zipPath = System.getProperty("user.home") + File.separator + "downloads" + File.separator + "temp";
        int total = objects.length;
        ArrayList<String> files = new ArrayList<String>(total);
        PageCache pageCache = pageId == null ? null : new PageCache(pageId);
        for (int i = 0; i < total; ++i) {
            DynamicObject dObj = objects[i];
            String tempFilePath = ExportAndImportFormUtil.generateLocalPath(new DynamicObject[]{dObj}, i + 1);
            files.add(tempFilePath);
            try (FileOutputStream out = new FileOutputStream(tempFilePath);){
                ExportDynamicObject.export((OutputStream)out, dObj);
                ExportAndImportFormUtil.refreshProgress(pageCache, total, i, null, true);
                continue;
            }
            catch (Exception e) {
                FileUtil.delete(files);
                ExportAndImportFormUtil.refreshProgress(pageCache, total, total - 1, e, true);
                logger.warn("\u5bfc\u51fa" + dObj.getDataEntityType().getName() + "\u5230" + tempFilePath + "\u51fa\u9519!", (Throwable)e);
                return;
            }
        }
        try {
            ExportAndImportFormUtil.compressFiles(objects[0].getDynamicObjectType(), files, zipPath, pageCache);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            ExportAndImportFormUtil.notifyError(pageCache, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void compressFiles(DynamicObjectType type, List<String> files, String zipPath, PageCache pageCache) throws IOException {
        String path;
        FileInputStream in;
        block4: {
            in = null;
            path = null;
            try {
                path = ZipUtils.compressFile(files, zipPath, ExportAndImportFormUtil.generateZipFileName(type));
                in = new FileInputStream(path);
                String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(path.substring(path.lastIndexOf(File.separator) + 1), (InputStream)in, 1800);
                FileUtil.addDownloadPermission(type.getName(), url, "iscb");
                if (pageCache == null) break block4;
                pageCache.put("url", url);
                pageCache.put("progress", "100");
            }
            catch (Exception e) {
                try {
                    logger.warn((Throwable)e);
                    ExportAndImportFormUtil.notifyError(pageCache, e);
                }
                catch (Throwable throwable) {
                    ExportAndImportFormUtil.close(in);
                    files.forEach(FileUtil::delete);
                    FileUtil.delete(path);
                    throw throwable;
                }
                ExportAndImportFormUtil.close(in);
                files.forEach(FileUtil::delete);
                FileUtil.delete(path);
            }
        }
        ExportAndImportFormUtil.close(in);
        files.forEach(FileUtil::delete);
        FileUtil.delete(path);
    }

    private static void close(InputStream in) throws IOException {
        if (in != null) {
            in.close();
        }
    }

    private static synchronized void notifyError(PageCache pageCache, Throwable e) {
        if (pageCache != null) {
            pageCache.remove("url");
            pageCache.put("errorstack", StringUtil.toString((Throwable)e));
            pageCache.put("text", ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38!", (String)"ExportAndImportFormUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            pageCache.put("progress", "100");
        }
    }

    public static synchronized void refreshProgress(PageCache pageCache, int total, int i, Throwable e) {
        ExportAndImportFormUtil.refreshProgress(pageCache, total, i, e, false);
    }

    public static synchronized void refreshProgress(PageCache pageCache, int total, int i, Throwable e, boolean hasNextAction) {
        if (pageCache == null) {
            return;
        }
        if (e != null) {
            ExportAndImportFormUtil.notifyError(pageCache, e);
            return;
        }
        float value = Math.min(100.0f, (float)(i + 1) * 100.0f / (float)total);
        String progress = ExportAndImportFormUtil.getNumberFormatter().format(value >= 100.0f && hasNextAction ? 99.99 : (double)value);
        pageCache.put("progress", progress);
    }

    private static NumberFormat getNumberFormatter() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        return numberFormat;
    }

    private static String generateZipFileName(DynamicObjectType entityType) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String date = df.format(new Date());
        return entityType.getDisplayName().getLocaleValue() + date;
    }

    @Deprecated
    public static void openImportForm(IFormPlugin form, IFormView view, String entityName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("isc_schema_upload");
        showParameter.setCustomParam("entityName", (Object)entityName);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack(form, "importschema"));
        view.showForm(showParameter);
    }

    public static String generateFileName(DynamicObject[] dObjects) {
        if (CollectionUtils.isEmpty(dObjects)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5bf9\u8c61\uff0c\u65e0\u6cd5\u5bfc\u51fa!", (String)"ExportAndImportFormUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String fileName = null;
        String displayName = dObjects[0].getDynamicObjectType().getDisplayName().getLocaleValue();
        String entityName = dObjects[0].getDynamicObjectType().getName().trim();
        String sessionId = Hash.mur16((Object[])new Object[]{RequestContext.get().getGlobalSessionId()});
        fileName = dObjects.length > 1 ? displayName + "(" + entityName + ")_" + sessionId : ExportAndImportFormUtil.generateSingleObjectFileName(dObjects[0], displayName, entityName, sessionId);
        return FileUtil.removeIllegalChar(fileName);
    }

    private static String generateSingleObjectFileName(DynamicObject dObject, String displayName, String entityName, String sessionId) {
        String fileName;
        if ("iscx_resource".equals(entityName)) {
            displayName = ExportAndImportFormUtil.iscxResourceNameProcess(dObject, displayName);
        }
        if ("isc_apic_permission".equals(entityName)) {
            String type = dObject.getString("type");
            String apiNum = dObject.getString("api.number");
            String callerNum = dObject.getString("caller.number");
            fileName = displayName + '_' + type + '_' + apiNum + '_' + callerNum + '_' + sessionId;
        } else if ("isc_solution_keywords".equals(entityName) || "isc_solution_source".equals(entityName)) {
            String name = dObject.getString("name");
            fileName = displayName + '_' + name + '_' + sessionId;
        } else {
            String id = dObject.getString("id");
            String number = dObject.getString("number");
            String name = dObject.getString("name");
            fileName = StringUtil.isEmpty((String)name) || StringUtil.isEmpty((String)number) ? displayName + '_' + id + '_' + sessionId : (ExportAndImportFormUtil.isNeedDistinct(entityName) ? displayName + '_' + name + '(' + number + ")_" + id + '_' + sessionId : displayName + '_' + name + '(' + number + ")_" + sessionId);
        }
        fileName = fileName.replace('(', '\uff08');
        fileName = fileName.replace(')', '\uff09');
        return fileName;
    }

    private static String iscxResourceNameProcess(DynamicObject dObject, String displayName) {
        String typeName = dObject.getString("type.name");
        displayName = displayName + "\uff08" + typeName + "\uff09";
        return displayName;
    }

    public static boolean isNeedDistinct(String entityName) {
        return "isc_metadata_schema".equals(entityName) || "isc_dataset_schema".equals(entityName);
    }

    public static String generateLocalPath(DynamicObject[] dObjects) {
        return ExportAndImportFormUtil.generateLocalPath(dObjects, -1);
    }

    public static String generateLocalPath(DynamicObject[] dObjects, int index) {
        String fileName = ExportAndImportFormUtil.generateFileName(dObjects);
        if (index > 0) {
            fileName = fileName + (95 + index);
        }
        return FileUtil.getLocalPath(fileName);
    }

    public static void download(IFormView view, String filePath) {
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        ExportAndImportFormUtil.download(view, filePath, fileName);
    }

    public static void download(IFormView view, String filePath, String fileName) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 1800);
            view.openUrl(urls);
        }
        catch (IOException e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4ece%s\u5730\u5740\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff01", (String)"ExportAndImportFormUtil_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filePath), (Throwable)e);
        }
        finally {
            boolean deleted;
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
            }
            if (deleted = FileUtil.delete(filePath)) {
                logger.info("\u6210\u529f\u5220\u9664\u7f13\u5b58\u6587\u4ef6" + filePath + ",\u5f53\u524d\u65f6\u95f4\uff1a" + LocalDate.now());
            } else {
                logger.warn("\u672a\u80fd\u5220\u9664\u7f13\u5b58\u6587\u4ef6" + filePath + ",\u5f53\u524d\u65f6\u95f4\uff1a" + LocalDate.now());
            }
        }
    }

    public static void exportPng(BufferedImage img, IFormView view, String fileName) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)img, "png", output);
            byte[] bytes = output.toByteArray();
            try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)input, 1800);
                view.openUrl(urls);
            }
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25!", (String)"ExportAndImportFormUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u56fe\u7247\u6210\u529f\u3002", (String)"ExportAndImportFormUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Integer.valueOf(1000));
    }

    public static String getDownloadFileName(DynamicObject api) {
        String type = api.getDataEntityType().getName();
        StringBuilder fileName = new StringBuilder();
        if (type == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u540d\u79f0\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301\u6587\u4ef6\u4e0b\u8f7d", (String)"ExportAndImportFormUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        fileName.append(ExportAndImportFormUtil.getDescription(type)).append(api.getString("name")).append('-');
        fileName.append(DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
        return fileName.toString();
    }

    public static String getDescription(String name) {
        return EntityMetadataCache.getDataEntityType((String)name).getDisplayName().getLocaleValue() + "-";
    }
}

