/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class IscExportUtil {
    public static void writeContent(OutputStream out, List<DynamicObject> refEntry, DynamicObject mainEntry) throws IOException {
        for (DynamicObject o : refEntry) {
            String entity = o.getDataEntityType().getName();
            String res_content = "ref_resources".equals(entity) ? o.getString("ref_res_content_tag") : o.getString("main_res_content_tag");
            IscExportUtil.write(out, res_content, true);
        }
        String main_res_content = mainEntry.getString("main_res_content_tag");
        IscExportUtil.write(out, main_res_content, false);
    }

    private static void write(OutputStream out, String content, boolean isref) throws IOException {
        HashMap map = (HashMap)Json.toObject((String)content);
        map.put("$isref", isref);
        content = Json.toString((Object)map);
        out.write(content.getBytes(StandardCharsets.UTF_8));
        out.write(10);
    }

    public static String generateFileName(DynamicObject mainEntry) {
        String entity = mainEntry.getString("main_res_type");
        String entityName = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().toString();
        String sessionId = Hash.mur16((Object[])new Object[]{RequestContext.get().getGlobalSessionId()});
        String number = mainEntry.getString("main_res_number");
        String name = mainEntry.getString("main_res_name");
        String id = mainEntry.getString("main_res_pk");
        String fileName = StringUtil.isEmpty((String)name) || StringUtil.isEmpty((String)number) ? entityName + '_' + id + '_' + sessionId : (ExportAndImportFormUtil.isNeedDistinct(entityName) ? entityName + '_' + name + '(' + number + ")_" + id + '_' + sessionId : entityName + '_' + name + '(' + number + ")_" + sessionId);
        fileName = fileName.replace('(', '\uff08');
        fileName = fileName.replace(')', '\uff09');
        String s = FileUtil.removeIllegalChar(fileName);
        return s;
    }

    public static String generateDtsName(DynamicObject[] dObjects, int index) {
        String fileName = ExportAndImportFormUtil.generateFileName(dObjects);
        if (index > 0) {
            fileName = fileName + (95 + index);
        }
        return fileName;
    }
}

