/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.isc.iscb.platform.core.util.MessageSender;
import kd.isc.iscb.util.misc.StringUtil;

public class MessageNoticeUtil {
    private static final Log log = LogFactory.getLog(MessageSender.class);

    public static void sendCosmicMessage(String person, String content, DynamicObject notice) {
        Set<Long> ids = MessageNoticeUtil.getUserIds(person);
        MessageInfo messageInfo = MessageNoticeUtil.getMessageInfo(content, ids, notice);
        log.info("\u5f85\u53d1\u9001\u7684\u6d88\u606f\u4f53\uff1a" + messageInfo);
        messageInfo.setContent(StringUtil.trim((String)content, (int)1000));
        long id = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        log.info("\u6d88\u606f\u4e2d\u5fc3\u8fd4\u56de\u7684\u6d88\u606fid:" + id);
    }

    private static Set<Long> getUserIds(String person) {
        String[] users = person.split(",");
        HashSet<Long> ids = new HashSet<Long>();
        if (users.length > 0) {
            for (String user : users) {
                ids.add(Long.valueOf(user.substring(user.indexOf(40) + 1, user.indexOf(41))));
            }
        }
        return ids;
    }

    private static MessageInfo getMessageInfo(String content, Set<Long> ids, DynamicObject notice) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("warning");
        messageInfo.setUserIds(new ArrayList<Long>(ids));
        messageInfo.setTag(ResManager.loadKDString((String)"\u96c6\u6210\u4e91", (String)"MessageNoticeUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        messageInfo.setTitle(notice.getString("msg_title"));
        messageInfo.setContent(content);
        return messageInfo;
    }
}

