/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.constant.ExecutionStatus;
import kd.isc.iscb.util.misc.StringUtil;

public class SendMsgUtil {
    private static final String FIELD_MODIFYTIME = "modifytime";
    private static final String FIELD_CREATETIME = "createtime";
    private static final String FIELD_END_TIME = "end_time";
    private static final String FIELD_START_TIME = "start_time";
    private static Log log = LogFactory.getLog(SendMsgUtil.class);
    private static final String ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";
    private static final String DATE_FORMAT_STR = "yyyy-MM-dd HH:mm:ss:SSS";

    private static String getDefaultContent() {
        return ResManager.loadKDString((String)"{name}\uff1a{number}\uff0c\u6267\u884c\u72b6\u6001\uff1a{state}\uff0c\u603b\u6570\uff1a{total_count}\uff1b\u5176\u4e2d \u6210\u529f {success_count}\uff0c\u5931\u8d25 {failed_count}\uff0c \u5ffd\u7565 {ignored_count}\uff1b\u5171\u6267\u884c{execute_count}\u6b21\uff0c\u6700\u540e\u4e00\u6b21\u6267\u884c\u4ece{start_time} \u81f3 {end_time}\uff0c\u8017\u65f6\uff1a{total_time}\uff1b", (String)"SendMsgUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    public static String getStrContainData(DynamicObject log, String str, String start, String end, boolean isSpecial) {
        if (StringUtils.isEmpty((String)str)) {
            str = SendMsgUtil.getDefaultContent();
        }
        String result = "";
        if (isSpecial) {
            start = "\\" + start;
            end = "\\" + end;
        }
        String regex = start + "(.*?)" + end;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        String value = "";
        while (matcher.find()) {
            String key = matcher.group(1);
            if (key.contains(start) || key.contains(end)) continue;
            value = SendMsgUtil.contentRevert(key, log);
            value = value == null ? ResManager.loadKDString((String)"\u672a\u586b\u5199", (String)"SendMsgUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : value;
            str = str.replaceAll("\\{" + key + "\\}", value);
        }
        result = str.trim();
        if (result.length() > 2000) {
            result = result.substring(0, 2000);
        }
        return result;
    }

    public static String getUrlInfo(String pkId) {
        StringBuilder url = new StringBuilder();
        String domain = UrlService.getDomainContextUrl();
        url.append(domain).append("formId=").append(ISC_DATA_COPY_EXECUTION).append("&formId=").append(ISC_DATA_COPY_EXECUTION).append("&pkId=").append(pkId).append("#/dform?formId=").append(ISC_DATA_COPY_EXECUTION).append("&pkId=").append(pkId);
        return url.toString();
    }

    public static String getUrlInfoWithModal(String pkId) {
        StringBuilder url = new StringBuilder();
        String domain = UrlService.getDomainContextUrl();
        url.append(domain).append("formId=").append(ISC_DATA_COPY_EXECUTION).append("&formId=").append(ISC_DATA_COPY_EXECUTION).append("&pkId=").append(pkId).append("#/dform?formId=").append(ISC_DATA_COPY_EXECUTION).append("&pkId=").append(pkId).append("&openStyle=modal");
        return url.toString();
    }

    public static void sendShortMesagge(String personInfo, String content) {
        if (StringUtils.isEmpty((String)personInfo)) {
            return;
        }
        try {
            ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
            shortMessageInfo.setMessage(content);
            ArrayList phones = new ArrayList();
            String[] persons = personInfo.split(";");
            Arrays.asList(persons).forEach(person -> phones.add(person.split(",")[1]));
            shortMessageInfo.setPhone(phones);
            log.info(String.format("\u77ed\u4fe1\u670d\u52a1\uff1a\u53d1\u9001\u6d88\u606f:message:%s,phones:%s", content, phones));
            shortMessageInfo.setMessage(StringUtil.trim((String)content, (int)400));
            MessageServiceHelper.sendShortMessage((ShortMessageInfo)shortMessageInfo);
            log.info(String.format("[%s-%s]\u53d1\u9001\u77ed\u4fe1\u6d88\u606f\u6210\u529f", RequestContext.get().getTraceId(), shortMessageInfo.getMessage()));
        }
        catch (Throwable e) {
            log.warn("\u77ed\u4fe1\u670d\u52a1\u53d1\u9001\u77ed\u4fe1\u5931\u8d25!", e);
        }
    }

    private static String getErrorMessage(Long exeId) {
        QFilter qf = new QFilter("state", "=", (Object)"F");
        qf.and(new QFilter("data_copy_execution", "=", (Object)exeId));
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)"isc_data_copy_exec_log", (String)"id,message,judgefields", (QFilter[])new QFilter[]{qf}, null, (int)0, (int)2);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < logs.length; ++i) {
            DynamicObject log = logs[i];
            sb.append('{');
            sb.append(i + 1);
            sb.append("}.");
            if (StringUtils.isNotEmpty((String)log.getString("judgefields"))) {
                sb.append(String.format(ResManager.loadKDString((String)"{\u6e90\u5355\u5019\u9009\u952e\u503c : %1$s}.", (String)"SendMsgUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), log.get("judgefields")));
            }
            sb.append(log.getString("message"));
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String contentRevert(String property, DynamicObject exe) {
        switch (property) {
            case "error_message": {
                return SendMsgUtil.getErrorMessage(Long.valueOf(exe.getPkValue().toString()));
            }
            case "state": {
                return ExecutionStatus.getDescByStatus(exe.getString(property));
            }
            case "modifytime": 
            case "createtime": 
            case "start_time": 
            case "end_time": {
                Date date = exe.getDate(property);
                if (date != null) {
                    return new SimpleDateFormat(DATE_FORMAT_STR).format(date);
                }
                return null;
            }
            case "total_time": {
                if (exe.getDate(FIELD_END_TIME) == null || exe.getDate(FIELD_START_TIME) == null) {
                    return "0";
                }
                return (exe.getDate(FIELD_END_TIME).getTime() - exe.getDate(FIELD_START_TIME).getTime()) / 1000L + String.format(ResManager.loadKDString((String)"\u79d2", (String)"SendMsgUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[0]);
            }
        }
        return exe.getString(property);
    }
}

