/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.constant.MessageType;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Event;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.context.Context;

public class SfMessageUtil
implements Const {
    private static final Log logger = LogFactory.getLog(SfMessageUtil.class);

    public static Map<Event, List<MessageInfo>> getServiceFlowMessage(long flowId) {
        QFilter[] qFilters = QFilterUtil.builder().put("flow", "=", flowId).put("status", "=", "1").build();
        DynamicObject[] msgObjs = BusinessDataServiceHelper.load((String)"isc_flow_notification", (String)"id,flow,execute,target_system,notice_method,recipient,recipient_noterp,recipientvar_erp,recipientvar_noterp,title,content", (QFilter[])qFilters);
        HashMap<Event, List<MessageInfo>> msgMap = new HashMap<Event, List<MessageInfo>>();
        for (DynamicObject msg : msgObjs) {
            SfMessageUtil.parseEvent(msg, msgMap);
        }
        return msgMap;
    }

    private static void parseEvent(DynamicObject msg, Map<Event, List<MessageInfo>> msgMap) {
        String execute = msg.getString("execute");
        if (execute.contains(MessageProcessState.Complete.name())) {
            SfMessageUtil.createAndAdd(msg, msgMap, Event.ON_COMPLETED);
        }
        if (execute.contains(MessageProcessState.Failed.name())) {
            SfMessageUtil.createAndAdd(msg, msgMap, Event.ON_SUSPENED);
        }
        if (execute.contains(MessageProcessState.Terminated.name())) {
            SfMessageUtil.createAndAdd(msg, msgMap, Event.ON_TERMINATED);
        }
    }

    private static void createAndAdd(DynamicObject msg, Map<Event, List<MessageInfo>> msgMap, Event event) {
        List msgObjList = msgMap.computeIfAbsent(event, k -> new ArrayList());
        msgObjList.add(new MessageInfo(msg));
    }

    public static List<Long> getMessagePerson(CompiledMessageInfo compiledInfo, Execution e) {
        MessageInfo info = compiledInfo.messageInfo;
        ArrayList<Long> recipients = new ArrayList<Long>();
        if (info.recipient != null) {
            recipients.addAll(info.recipient);
        }
        if (info.recipient_noterp != null) {
            recipients.addAll(info.recipient_noterp);
        }
        if (!compiledInfo.innerRecipientVariableFormats.isEmpty()) {
            List<Long> inner_person = SfMessageUtil.parsePerson(compiledInfo.innerRecipientVariableFormats, e);
            if (inner_person.isEmpty() || info.recipientvar_erp.size() > inner_person.size()) {
                logger.warn(String.format("\u6839\u636e\u82cd\u7a79\u7528\u6237\uff08\u53d8\u91cf\uff09:%s,\u83b7\u53d6\u5230\u7684\u5b9e\u9645\u53d8\u91cf\u503c\u4e3a\uff1a%s", info.recipientvar_erp.toString(), inner_person.toString()));
            }
            recipients.addAll(inner_person);
        }
        if (info.recipientvar_noterp != null) {
            List<Long> outer_person = SfMessageUtil.parsePerson(compiledInfo.outerRecipientVariableFormats, e);
            if (outer_person.isEmpty() || info.recipientvar_noterp.size() > outer_person.size()) {
                logger.warn(String.format("\u6839\u636e\u975e\u82cd\u7a79\u7528\u6237\uff08\u53d8\u91cf\uff09:%s,\u83b7\u53d6\u5230\u7684\u5b9e\u9645\u53d8\u91cf\u503c\u4e3a\uff1a%s", info.recipientvar_noterp.toString(), outer_person.toString()));
            }
            recipients.addAll(outer_person);
        }
        return recipients;
    }

    private static List<Long> parsePerson(Set<Script> vars, Execution e) {
        ArrayList<Long> ids = new ArrayList<Long>();
        Object id = null;
        for (Script script : vars) {
            try {
                id = script.eval((Context)e);
                if (id == null) continue;
                SfMessageUtil.selectAndAddPersonIds(id, ids);
            }
            catch (Exception err) {
                logger.warn(String.format("\u4eba\u5458\u53d8\u91cf\u89e3\u6790\u9519\u8bef\uff0c\u5f53\u524d\u4eba\u5458\u53d8\u91cf\u4e3a\uff1a%s,\u89e3\u6790\u4e4b\u540e\u4eba\u5458\u4e3a\uff1a%s", script.toString(), id), (Throwable)err);
            }
        }
        return ids;
    }

    private static void selectAndAddPersonIds(Object id, List<Long> ids) {
        if (id instanceof Map) {
            Map map = (Map)id;
            long tmp = D.l(map.get("id"));
            if (tmp != 0L) {
                ids.add(tmp);
            }
        } else if (id instanceof Collection) {
            Collection tmp = (Collection)id;
            for (Object o : tmp) {
                SfMessageUtil.selectAndAddPersonIds(o, ids);
            }
        } else {
            ids.add(D.l((Object)id));
        }
    }

    public static enum MessageProcessState {
        Failed(Event.ON_SUSPENED, new MultiLangEnumBridge("\u5df2\u5931\u8d25", "SfMessageUtil_10", "isc-iscb-platform-core")),
        Complete(Event.ON_COMPLETED, new MultiLangEnumBridge("\u5df2\u7ed3\u675f", "SfMessageUtil_11", "isc-iscb-platform-core")),
        Terminated(Event.ON_TERMINATED, new MultiLangEnumBridge("\u5df2\u64a4\u9500", "SfMessageUtil_12", "isc-iscb-platform-core"));

        private Event event;
        private MultiLangEnumBridge desc;

        private MessageProcessState(Event event, MultiLangEnumBridge desc) {
            this.event = event;
            this.desc = desc;
        }

        public static String getStateByEvent(Event event) {
            for (MessageProcessState state : MessageProcessState.values()) {
                if (state.event != event) continue;
                return state.desc.loadKDString();
            }
            return null;
        }
    }

    public static enum SfProperty {
        number("$process.flow.number", new MultiLangEnumBridge("\u7f16\u7801", "SfMessageUtil_3", "isc-iscb-platform-core")),
        name("$process.flow.name", new MultiLangEnumBridge("\u540d\u79f0", "SfMessageUtil_4", "isc-iscb-platform-core")),
        state("$process.state", new MultiLangEnumBridge("\u6267\u884c\u72b6\u6001", "SfMessageUtil_5", "isc-iscb-platform-core")),
        version("$process.flow.version", new MultiLangEnumBridge("\u7248\u672c\u53f7", "SfMessageUtil_6", "isc-iscb-platform-core")),
        creator("$process.creator.name", new MultiLangEnumBridge("\u53d1\u8d77\u4eba", "SfMessageUtil_7", "isc-iscb-platform-core")),
        modifier("$process.modifier.name", new MultiLangEnumBridge("\u4fee\u6539\u4eba", "SfMessageUtil_8", "isc-iscb-platform-core")),
        created_time("$process.created_time", new MultiLangEnumBridge("\u521b\u5efa\u65f6\u95f4", "SfMessageUtil_9", "isc-iscb-platform-core"));

        private final String pro;
        private final MultiLangEnumBridge desc;

        private SfProperty(String pro, MultiLangEnumBridge desc) {
            this.pro = pro;
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc.loadKDString();
        }

        public String getPro() {
            return this.pro;
        }
    }

    public static class MessageInfo {
        private String target_system;
        private String channel;
        private Set<Long> recipient;
        private Set<Long> recipient_noterp;
        private Set<String> recipientvar_erp;
        private Set<String> recipientvar_noterp;
        private String title;
        private String content;

        MessageInfo(DynamicObject msg) {
            this(msg.getString("target_system"), msg.getString("notice_method"), msg.getString("recipient"), msg.getString("recipient_noterp"), msg.getString("recipientvar_erp"), msg.getString("recipientvar_noterp"), msg.getString("title"), msg.getString("content"));
        }

        MessageInfo(String target_system, String channel, String recipient, String recipient_noterp, String recipientvar_erp, String recipientvar_noterp, String title, String content) {
            this.target_system = target_system;
            this.channel = channel;
            this.recipient = this.spiltUserIds(recipient);
            this.recipient_noterp = this.splitUserPhone(recipient_noterp);
            this.recipientvar_erp = this.getVars(recipientvar_erp);
            this.recipientvar_noterp = this.getVars(recipientvar_noterp);
            this.title = title;
            this.content = content;
        }

        private Set<Long> spiltUserIds(String recipient) {
            HashSet<Long> ids = new HashSet<Long>();
            if (StringUtils.isEmpty((String)recipient)) {
                return ids;
            }
            String[] users = recipient.split(",");
            if (users.length > 0) {
                for (String user : users) {
                    ids.add(Long.valueOf(user.substring(user.indexOf(40) + 1, user.indexOf(41))));
                }
            }
            return ids;
        }

        private Set<Long> splitUserPhone(String recipient_noterp) {
            HashSet<Long> phones = new HashSet<Long>();
            if (StringUtils.isEmpty((String)recipient_noterp)) {
                return phones;
            }
            String[] userPhones = recipient_noterp.split(";");
            if (userPhones.length > 0) {
                Arrays.asList(userPhones).forEach(person -> phones.add(D.l((Object)person.split(",")[1])));
            }
            return phones;
        }

        private Set<String> getVars(String varStr) {
            if (StringUtils.isEmpty((String)varStr)) {
                return new HashSet<String>();
            }
            String[] vars = varStr.split(";");
            return new HashSet<String>(Arrays.asList(vars));
        }
    }

    public static class CompiledMessageInfo {
        private MessageInfo messageInfo;
        private Set<Script> innerRecipientVariableFormats;
        private Set<Script> outerRecipientVariableFormats;
        private Format titleFormat;
        private Format contentFormat;

        private static String getDefaultContent() {
            return ResManager.loadKDString((String)"#{$process.flow.name}\uff08#{$process.flow.number}\uff09\uff1a\u72b6\u6001 : #{$process.state}\uff0c\u7531#{$process.creator.name} \u5728 #{$process.created_time} \u53d1\u8d77\u3002", (String)"SfMessageUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }

        private static String getDefaultTitle() {
            return ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u201c#{$process.flow.name}\u201d\u901a\u77e5", (String)"SfMessageUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }

        public CompiledMessageInfo(MessageInfo messageInfo, Map<String, Object> ctx) {
            this.messageInfo = messageInfo;
            this.innerRecipientVariableFormats = this.compilePersons(this.messageInfo.recipientvar_erp, ctx);
            this.outerRecipientVariableFormats = this.compilePersons(this.messageInfo.recipientvar_noterp, ctx);
            this.titleFormat = Format.parse((String)(StringUtils.isEmpty((String)messageInfo.title) ? CompiledMessageInfo.getDefaultTitle() : messageInfo.title), ctx);
            this.contentFormat = Format.parse((String)(StringUtils.isEmpty((String)messageInfo.content) ? CompiledMessageInfo.getDefaultContent() : messageInfo.content), ctx);
        }

        private Set<Script> compilePersons(Set<String> recipientVars, Map<String, Object> ctx) {
            HashSet<Script> scripts = new HashSet<Script>(recipientVars.size());
            for (String person : recipientVars) {
                Script personFormat = Script.compile((String)person, ctx);
                scripts.add(personFormat);
            }
            return scripts;
        }

        public void buildMessageAndSend(Execution e) {
            MessageType.Message message = new MessageType.Message();
            message.setFinalMsgTitle(this.titleFormat.translate((Context)e));
            message.setFinalMsgContent(this.contentFormat.translate((Context)e) + "\r\n" + String.format(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u83dc\u5355\u201c\u96c6\u6210\u7ba1\u7406-\u670d\u52a1\u7f16\u6392-\u6d41\u7a0b\u5b9e\u4f8b\u201c\u67e5\u770b\u7f16\u7801\u662f%s\u7684\u6d41\u7a0b\u5b9e\u4f8b\u8fdb\u884c\u5206\u6790\u5904\u7406\u3002", (String)"SfMessageUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getRuntime().getProperties().get("number")));
            message.setNoticeMethod(this.messageInfo.channel);
            message.setRecipients(SfMessageUtil.getMessagePerson(this, e));
            message.setContentUrl(this.getQuickUrl(e.getRuntime().getId()));
            MessageType.valueOf(this.messageInfo.target_system).send(message);
        }

        private String getQuickUrl(String id) {
            StringBuilder url = new StringBuilder();
            url.append(UrlService.getDomainContextUrl()).append("?formId=").append("isc_sf_proc_inst").append("&pkId=").append(id).append("&openStyle=modal");
            return url.toString();
        }
    }
}

