/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.form.IFormView;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.i.AbstractSimpleDataType;
import kd.isc.iscb.util.dt.i.UnknownType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class SfRuntimeUtil {
    public static FlowRuntime getFlowRuntime(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        long procInstId = D.l(params.get("proc_inst_id"));
        if (procInstId == 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e3a\u7a7a", (String)"SfRuntimeUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return ProcessRuntime.loadRuntime(procInstId);
    }

    public static void updateVar(long procInstId, String varName, Object newVal, RequestContext ctx, Timestamp lastUpdateTime) {
        FlowRuntime runtime = ProcessRuntime.loadRuntime(procInstId);
        Variable variable = runtime.getFlow().getVariable(varName);
        DataType type = variable.getType();
        Object oldVal = runtime.get(varName);
        newVal = SfRuntimeUtil.setNewValToRuntime(varName, newVal, runtime, type);
        if (!SfRuntimeUtil.updateProcInstInDb(procInstId, runtime, ctx, lastUpdateTime)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6d41\u7a0b\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u6d41\u7a0b\u540e\u91cd\u65b0\u64cd\u4f5c", (String)"SfRuntimeUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        ProcessRuntime.saveControlLog(procInstId, SfRuntimeUtil.getLogInfo(varName, newVal, oldVal, ctx.getUserName()));
    }

    private static Object setNewValToRuntime(String varName, Object newVal, FlowRuntime runtime, DataType type) {
        try {
            if (type instanceof UnknownType || !(type instanceof AbstractSimpleDataType)) {
                newVal = Json.toObject((String)D.s((Object)newVal));
            }
            runtime.set(varName, newVal);
        }
        catch (Exception e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u4fee\u6539\u53d8\u91cf\u503c\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u6570\u636e\u7c7b\u578b\u53ca\u662f\u5426\u591a\u503c\u8c03\u6574\u597d\u4fee\u6539\u503c", (String)"SfRuntimeUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
        return newVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateProcInstInDb(long procInstId, FlowRuntime runtime, RequestContext ctx, Timestamp lastUpdateTime) {
        String updateSql = "update T_ISC_SF_PROC_INST set fmodifier = ?,fmodified_time = ?,fcontext = ? ,fcontext_tag = ? where fid = ? and fstate = ? and fmodified_time = ?";
        String digest = StringUtil.trim((String)ProcessRuntime.generateDigest(runtime), (int)100);
        String contextTag = Json.toString((Object)runtime.toJson(), (boolean)true);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        List<Object> values = Arrays.asList(ctx.getUserId(), now, digest, contextTag, procInstId, "Failed", lastUpdateTime);
        List<Integer> types = Arrays.asList(-5, 93, 12, 12, -5, 12, 93);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[1]);
        try {
            int i = DbUtil.executeUpdate((Connection)cn, (String)updateSql, values, types);
            boolean bl = i == 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static String getLogInfo(String varName, Object newVal, Object oldVal, String userName) {
        return String.format(ResManager.loadKDString((String)"\u53d8\u91cf\uff08%1$s\uff09\u7684\u5185\u5bb9\u6539\u53d8\u4e86\u3002\u4fee\u6539\u4eba\uff1a%2$s", (String)"SfRuntimeUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), varName, userName) + "\r\n" + String.format(ResManager.loadKDString((String)"\u65b0\u503c\uff1a%s", (String)"SfRuntimeUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.trim((Object)newVal, (int)8000)) + "\r\n" + String.format(ResManager.loadKDString((String)"\u539f\u503c\uff1a%s", (String)"SfRuntimeUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.trim((Object)oldVal, (int)8000));
    }
}

