/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class ZipUtils {
    public static String compressFile(List<String> filePaths, String zipPath, String zipName) throws IOException {
        File zipFile = ZipUtils.createZipFile(zipPath, zipName);
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zipOutputStream = new ZipOutputStream(fos);){
            for (String file : filePaths) {
                FileInputStream fileInputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    int len;
                    ZipEntry zipEntry = new ZipEntry(file.substring(file.lastIndexOf(File.separator) + 1));
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] buffer = new byte[1024];
                    while ((len = fileInputStream.read(buffer)) > 0) {
                        zipOutputStream.write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
        }
        catch (IOException e) {
            FileUtil.delete(zipFile.getAbsolutePath());
            throw e;
        }
        return zipFile.getAbsolutePath();
    }

    public static File createZipFile(String path, String zipName) throws IOException {
        File zipFile;
        boolean created;
        String name = zipName;
        if (!zipName.endsWith(".zip")) {
            name = zipName + ".zip";
        }
        if (!(created = (zipFile = new File(path + File.separator + name)).createNewFile())) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"zip\u6587\u4ef6%s\u5df2\u5b58\u5728!", (String)"ZipUtils_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), zipFile.getAbsolutePath()));
        }
        return zipFile;
    }

    public static File compressFolder(File dir) throws Exception {
        String parent = dir.getParent();
        String name = dir.getName();
        File zipFile = ZipUtils.createZipFile(parent, name);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));){
            ZipUtils.writeZip(dir, name, zipOutputStream);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        finally {
            FileUtil.deleteAll(dir);
        }
        return zipFile;
    }

    private static void writeZip(File file, String name, ZipOutputStream output) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                output.putNextEntry(new ZipEntry(name + File.separator));
            } else {
                for (File f : files) {
                    ZipUtils.writeZip(f, name + File.separator + f.getName(), output);
                }
            }
        } else {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                int len;
                ZipEntry entry = new ZipEntry(name);
                output.putNextEntry(entry);
                byte[] bytes = new byte[1024];
                while ((len = bis.read(bytes, 0, bytes.length)) != -1) {
                    output.write(bytes, 0, len);
                    output.flush();
                }
            }
        }
    }
}

