/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util.setter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.platform.core.connector.self.RetrieveData;
import kd.isc.iscb.platform.core.proxy.BusinessDataServiceHelperProxy;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.platform.core.util.setter.BasedataPropSetter;
import kd.isc.iscb.platform.core.util.setter.Setter;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public abstract class AbstractComplexPropSetter
implements Setter {
    protected String entity;

    public AbstractComplexPropSetter(String entity) {
        this.entity = entity;
    }

    protected abstract DynamicObjectType getDynamicObjectType(String var1);

    protected boolean isEmptyMap(Map<String, Object> valueMap) {
        for (Object value : valueMap.values()) {
            if (value == null || "".equals(value)) continue;
            return false;
        }
        return true;
    }

    protected DynamicObject queryByCondition(Map<String, Object> map, String entity) {
        if (CollectionUtils.isEmpty(map)) {
            return null;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(map.size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String field = entry.getKey();
            Object value = entry.getValue();
            if (entityType.getProperty(field) == null) continue;
            Object newValue = RetrieveData.cast((EntityType)entityType, field, value);
            filters.add(new QFilter(field, "=", newValue));
        }
        DynamicObjectType objectType = this.getDynamicObjectType(entity);
        return BusinessDataServiceHelperProxy.loadSingleByFilter(objectType, filters.toArray(new QFilter[0]));
    }

    protected void setMapRefs(DynamicObject object, String property, Map<String, Object> valueMap) {
        DynamicObject resultObj;
        if (this.isEmptyMap(valueMap)) {
            object.set(property, null);
            return;
        }
        HashMap<String, Object> entries = new HashMap<String, Object>(valueMap);
        Object id = entries.remove("id");
        Object defaultKey = entries.remove("$default");
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        if (id != null) {
            idMap.put("id", id);
        }
        if ((resultObj = this.queryByCondition(idMap, this.entity)) != null) {
            object.set(property, (Object)resultObj);
            return;
        }
        resultObj = this.queryByCondition(entries, this.entity);
        if (resultObj != null) {
            object.set(property, (Object)resultObj);
            return;
        }
        if (defaultKey != null) {
            idMap.put("id", defaultKey);
            resultObj = this.queryByCondition(idMap, this.entity);
        }
        if (resultObj == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6%1$s\u65e0\u6cd5\u5728\u76ee\u6807\u7cfb\u7edf\u627e\u5230%2$s\u7684ID.", (String)"BasedataPropSetter_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), valueMap, property));
        }
        object.set(property, (Object)resultObj);
    }

    @Override
    public abstract void setObjValue(DynamicObject var1, String var2, Object var3);

    @Override
    public void setMapValue(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject obj) {
        Object val = obj.get(property);
        if (val == null) {
            map.put(property, null);
        } else if (val instanceof DynamicObject) {
            if (requires != null && !requires.isEmpty()) {
                DynamicObject simpleObj = (DynamicObject)val;
                if (requires.get(property) instanceof Map) {
                    Map childSelectors = (Map)requires.get(property);
                    map.put(property, DynamicObjectUtil.object2Map(simpleObj, childSelectors));
                } else {
                    map.put(property, simpleObj.getPkValue());
                }
            }
        } else if (val instanceof Long) {
            map.put(property, Long.valueOf(0L).equals(val) ? null : val);
        } else if (val instanceof String) {
            map.put(property, D.s((Object)val));
        }
    }

    @Override
    public void setRequiresMap(String property, Map<String, Object> dbRequires, Map<String, Object> requires) {
        Object value = requires.get(property);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.entity);
        if (value != null) {
            if (value instanceof Map) {
                BasedataPropSetter.recursiveSetValue(property, dbRequires, (IDataEntityType)type, (Map)value);
            } else {
                dbRequires.put(property, value);
            }
        }
    }

    @Override
    public abstract void setSchema(Map<String, Object> var1, String var2, String var3);
}

