/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util.setter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.isc.iscb.platform.core.connector.self.AttachmentField;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.setter.MulBasedataPropSetter;
import kd.isc.iscb.platform.core.util.setter.Setter;

public class AttachmentPropSetter
implements Setter {
    private AttachmentProp attachmentProp;
    private MulBasedataPropSetter setter;

    public AttachmentPropSetter(AttachmentProp attachmentProp) {
        this.attachmentProp = attachmentProp;
        this.setter = new MulBasedataPropSetter((MulBasedataProp)attachmentProp);
    }

    @Override
    public void setObjValue(DynamicObject object, String property, Object value) {
        if (CommonUtil.isEmpty(value)) {
            object.set(property, null);
        } else if (value instanceof List) {
            List<Object> pks = this.getAttachmentPks(object, property, (List)value);
            this.setter.setObjValue(object, property, pks);
        } else if (value instanceof Map) {
            Object id = ((Map)value).get("id");
            if (id != null) {
                this.setter.setObjValue(object, property, Collections.singleton(id));
            }
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u53c2\u6570%1$s\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4e0d\u652f\u6301%2$s\u7c7b\u578b\u8d4b\u503c.", (String)"AttachmentPropSetter_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), property, value.getClass()));
        }
    }

    private List<Object> getAttachmentPks(DynamicObject object, String property, List<?> value) {
        ArrayList<Object> pks = new ArrayList<Object>(value.size());
        Iterator<?> iterator = value.iterator();
        while (iterator.hasNext()) {
            Object v;
            Object pk = v = iterator.next();
            if (v instanceof Map) {
                pk = ((Map)v).get("id");
            }
            pks.add(pk);
        }
        AttachmentField attach = new AttachmentField(object.getDynamicObjectType().getName(), property);
        attach.bind(object, pks);
        return pks;
    }

    @Override
    public void setMapValue(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject obj) {
        this.setter.setMapValue(map, requires, property, obj);
    }

    @Override
    public void setSchema(Map<String, Object> map, String parentEntityName, String property) {
        map.put("data_type", "ENTRIES");
        map.put("data_schema", "bd_attachment");
        map.put("is_nullable", !this.attachmentProp.isMustInput());
        map.put("label", ResManager.loadKDString((String)"\u9644\u4ef6", (String)"AttachmentPropSetter_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    @Override
    public void setRequiresMap(String property, Map<String, Object> dbRequires, Map<String, Object> requires) {
        Object value = requires.get(property);
        if (value instanceof Map) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u82cd\u7a79\u9644\u4ef6\u5b57\u6bb5%s\u5f15\u7528\u5c5e\u6027\u53d6\u503c\uff0c\u8bf7\u5c06\u76f8\u5173\u5b57\u6bb5\u79fb\u9664\u3002\u5982\u9700\u540c\u6b65\u9644\u4ef6\uff0c\u8bf7\u914d\u7f6e\u96c6\u6210\u65b9\u6848\u5b57\u6bb5\u6620\u5c04\u5b9e\u73b0\u3002", (String)"AttachmentPropSetter_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), property));
        }
        dbRequires.put(property, value);
    }
}

