/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.util.setter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.session.SystemPropertyUtils;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.proxy.BusinessDataServiceHelperProxy;
import kd.isc.iscb.platform.core.util.setter.AbstractComplexPropSetter;
import kd.isc.iscb.util.dt.D;

public class BasedataPropSetter
extends AbstractComplexPropSetter {
    private BasedataProp baseData;

    public BasedataPropSetter(BasedataProp baseData) {
        super(baseData.getBaseEntityId());
        this.baseData = baseData;
    }

    public BasedataPropSetter(BasedataProp baseData, String entity) {
        super(entity);
        this.baseData = baseData;
    }

    @Override
    public void setObjValue(DynamicObject object, String property, Object value) {
        if (value == null) {
            object.set(property, null);
            return;
        }
        if (value instanceof Map) {
            Map keys = (Map)value;
            this.setMapRefs(object, property, keys);
        } else if (value instanceof Collection) {
            this.setMultiRefs(object, property, (Collection)value);
        } else if (value instanceof String) {
            this.setStringRef(object, property, (String)value);
        } else if (value instanceof Number) {
            this.setSingleRef(object, property, D.l((Object)value));
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027%1$s\u8d4b\u503c\u7c7b\u578b\u4e0d\u5408\u6cd5\uff0c\u5b9e\u9645\u7c7b\u578b\uff1a%2$s", (String)"BasedataPropSetter_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), property, value.getClass().getSimpleName()));
        }
    }

    private void setSingleRef(DynamicObject object, String property, Object id) {
        if (D.s((Object)id) == null) {
            object.set(property, null);
        } else if (id instanceof Number && Long.valueOf(0L).equals(id)) {
            object.set(property, null);
        } else {
            DynamicObject obj = this.loadSingle(id, this.entity);
            object.set(property, (Object)obj);
        }
    }

    private void setStringRef(DynamicObject object, String property, String id) {
        if (id.indexOf(44) > 0) {
            this.setMultiRefs(object, property, this.entity, id);
        } else {
            this.setSingleRef(object, property, id);
        }
    }

    private void setMultiRefs(DynamicObject object, String property, Collection<?> value) {
        ArrayList<DynamicObject> refs = new ArrayList<DynamicObject>();
        for (Object id : value) {
            if (D.s(id) == null) continue;
            DynamicObject obj = this.loadSingle(id, this.entity);
            refs.add(obj);
        }
        object.set(property, refs);
    }

    private void setMultiRefs(DynamicObject object, String property, String entity, String s) {
        ArrayList<DynamicObject> refs = new ArrayList<DynamicObject>();
        for (String id : s.split(",")) {
            if (D.s((Object)id) == null) continue;
            DynamicObject obj = this.loadSingle(id, entity);
            refs.add(obj);
        }
        object.set(property, refs);
    }

    private DynamicObject loadSingle(Object id, String entity) {
        DynamicObjectType type = this.getDynamicObjectType(entity);
        return BusinessDataServiceHelperProxy.loadSingle(id, type);
    }

    @Override
    protected DynamicObjectType getDynamicObjectType(String entity) {
        String queryAll = SystemPropertyUtils.getProptyByTenant((String)"isc.basedata.queryall", (String)RequestContext.get().getTenantId());
        if ("true".equals(queryAll)) {
            return EntityMetadataCache.getDataEntityType((String)entity);
        }
        if (this.baseData instanceof ItemClassProp) {
            String typePropName = ((ItemClassProp)this.baseData).getTypePropName();
            ItemClassTypeProp typeProp = (ItemClassTypeProp)this.baseData.getParent().getProperties().get((Object)typePropName);
            DynamicObjectType type = (DynamicObjectType)typeProp.getItemTypes().get(entity);
            return type != null ? type : EntityMetadataCache.getDataEntityType((String)entity);
        }
        return this.baseData.getDynamicComplexPropertyType();
    }

    @Override
    public void setSchema(Map<String, Object> map, String parentEntityName, String property) {
        map.put("data_type", "REF");
        map.put("data_schema", this.baseData.getBaseEntityId());
        map.put("is_nullable", !this.baseData.isMustInput());
        map.put("label", this.baseData.getDisplayName().toString());
    }

    public static void recursiveSetValue(String property, Map<String, Object> dbRequires, IDataEntityType type, Map value) {
        HashMap<String, Object> subRequires = null;
        if (!dbRequires.containsKey(property)) {
            subRequires = new HashMap();
            dbRequires.put(property, subRequires);
        } else {
            subRequires = (Map)dbRequires.get(property);
        }
        SQLUtil.filterRequires(type, subRequires, value);
    }
}

