/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.vc;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.vc.ValueConversionRule;

public class ValueConversionCacheManage {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TAR = "tar";
    private static final String FIELD_SRC = "src";
    private static final String FIELD_CONVERT_RULE = "convert_rule";
    private static final String ISC_VALUE_CONVERT_CACHE = "isc_value_convert_cache";
    private static final IAppCache cache = AppCache.get((String)"ISCB");

    public static synchronized Object get(ValueConversionRule rule, Object src) {
        Object tar;
        if (src == null) {
            return null;
        }
        if (rule.useRedisCache() && (tar = cache.get(ValueConversionCacheManage.getKey(rule, src), String.class)) != null) {
            return tar;
        }
        if (rule.useDbCache() && (tar = ValueConversionCacheManage.getDbCache(rule, src)) != null) {
            ValueConversionCacheManage.putToRedisCache(ValueConversionCacheManage.getKey(rule, src), tar);
            return tar;
        }
        return null;
    }

    public static synchronized Object get2(ValueConversionRule rule, Object src, long srcDblinkID, long tarDblinkID) {
        Object tar;
        if (src == null) {
            return null;
        }
        if (rule.useRedisCache() && (tar = cache.get(ValueConversionCacheManage.getKey2(rule, src, srcDblinkID, tarDblinkID), String.class)) != null) {
            return tar;
        }
        return null;
    }

    public static synchronized void save(ValueConversionRule rule, Object src, Object tar) {
        if (src == null || tar == null) {
            return;
        }
        if (rule.useRedisCache()) {
            String key = ValueConversionCacheManage.getKey(rule, src);
            ValueConversionCacheManage.putToRedisCache(key, tar);
        }
        if (rule.useDbCache()) {
            ValueConversionCacheManage.saveDbCache(rule, src, tar);
        }
    }

    public static synchronized void clearRedisCache(DynamicObject rule, Object src) {
        String key = ValueConversionCacheManage.getKey(rule.getString("number"), src);
        cache.remove(key);
    }

    public static String getKey(String ruleNumber, Object src) {
        return ruleNumber + ":" + src;
    }

    private static String getKey(ValueConversionRule rule, Object src) {
        return ValueConversionCacheManage.getKey(rule.name(), src);
    }

    public static synchronized void save2(ValueConversionRule rule, Object src, Object tar, long srcDblinkID, long tarDblinkID) {
        if (src == null || tar == null) {
            return;
        }
        if (rule.useRedisCache()) {
            String key = ValueConversionCacheManage.getKey2(rule, src, srcDblinkID, tarDblinkID);
            ValueConversionCacheManage.putToRedisCache(key, tar);
        }
    }

    public static String getKey2(String ruleNumber, Object src, long srcDblinkID, long tarDblinkID) {
        return ruleNumber + ":" + src + ":" + srcDblinkID + ":" + tarDblinkID;
    }

    private static String getKey2(ValueConversionRule rule, Object src, long srcDblinkID, long tarDblinkID) {
        return ValueConversionCacheManage.getKey2(rule.name(), src, srcDblinkID, tarDblinkID);
    }

    private static synchronized void putToRedisCache(String key, Object tar) {
        cache.remove(key);
        cache.put(key, tar);
    }

    private static Object getDbCache(ValueConversionRule rule, Object src) {
        DynamicObject object = ValueConversionCacheManage.getCacheDynamicObject(rule, src);
        return object == null ? null : object.get(FIELD_TAR);
    }

    private static void saveDbCache(ValueConversionRule rule, Object src, Object tar) {
        DynamicObject object = ValueConversionCacheManage.getCacheDynamicObject(rule, src);
        object = object == null ? BusinessDataServiceHelper.newDynamicObject((String)ISC_VALUE_CONVERT_CACHE) : BusinessDataServiceHelper.loadSingle((Object)object.get(FIELD_ID), (String)ISC_VALUE_CONVERT_CACHE);
        object.set(FIELD_CONVERT_RULE, (Object)rule.getRuleConfig());
        object.set(FIELD_SRC, src);
        object.set(FIELD_TAR, tar);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    private static DynamicObject getCacheDynamicObject(ValueConversionRule rule, Object src) {
        DynamicObject ruleConfig = rule.getRuleConfig();
        QFilter filter = new QFilter(FIELD_CONVERT_RULE, "=", ruleConfig.getPkValue()).and(new QFilter(FIELD_SRC, "=", src));
        return QueryServiceHelper.queryOne((String)ISC_VALUE_CONVERT_CACHE, (String)"id, tar", (QFilter[])new QFilter[]{filter});
    }
}

