/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.vc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.meta.MetaUtil;
import kd.isc.iscb.platform.core.vc.ValueConversionCacheManage;
import kd.isc.iscb.platform.core.vc.ValueConversionRule;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class ValueConversionRuleProxy
implements ValueConversionRule {
    private static final String NULL_CONSTANT = "NULL_CONSTANT";
    private ValueConversionRule rule;

    ValueConversionRuleProxy(ValueConversionRule rule) {
        this.rule = rule;
    }

    @Override
    public DynamicObject getRuleConfig() {
        return this.rule.getRuleConfig();
    }

    @Override
    public ConnectionWrapper getSourceConnection() {
        return this.rule.getSourceConnection();
    }

    @Override
    public ConnectionWrapper getTargetConnection() {
        return this.rule.getTargetConnection();
    }

    @Override
    public Object cast(String src) {
        if (src == null) {
            return null;
        }
        Object tar = ValueConversionCacheManage.get(this.rule, src);
        if (tar == null || tar.equals(NULL_CONSTANT)) {
            tar = this.rule.cast(src);
            if (tar == null && this.rule.getRuleConfig().get("data_copy_trigger") != null) {
                String execution = this.doDataCopy(src);
                tar = this.rule.cast(src);
                if (tar == null) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u6267\u884c\u7ed3\u679c\uff08%s\uff09\u4ece\u6e90\u7cfb\u7edf\u540c\u6b65\u4e861\u884c\u6570\u636e\u5230\u76ee\u6807\u7cfb\u7edf\uff0c\u4f46\u503c\u8f6c\u6362\u89c4\u5219\u6267\u884c\u7ed3\u679c\u4ecd\u7136\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8be5\u542f\u52a8\u65b9\u6848\u4e0e\u503c\u8f6c\u6362\u89c4\u5219\u662f\u5426\u5339\u914d\u3002", (String)"ValueConversionRuleProxy_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), execution));
                }
            }
            ValueConversionCacheManage.save(this.rule, src, tar != null ? tar : NULL_CONSTANT);
        }
        return tar;
    }

    private String doDataCopy(String src) {
        String pk = this.getSourcePrimaryKey();
        Map<String, Object> data = this.prepareDataCopyFilter(src, pk);
        long id = D.l((Object)this.rule.getRuleConfig().get("data_copy_trigger_id"));
        DynamicObject trigger = DataCopyTrigger.get(id);
        DynamicObject execution = DataCopyTask.create(trigger, null, null, null, data, DataCopyTask.InitType.AUTO_COM);
        int count = DataCopyTask.execute(execution);
        if (count == 1) {
            return execution.getString("number");
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u6267\u884c\u7ed3\u679c\uff08%1$s\uff09\u7684\u603b\u884c\u6570\u662f%2$s\u884c\uff0c\u4e0d\u7b26\u5408\u81ea\u52a8\u6570\u636e\u96c6\u6210\u7684\u8981\u6c42\u3002", (String)"ValueConversionRuleProxy_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), execution.get("number"), count));
    }

    private Map<String, Object> prepareDataCopyFilter(String src, String pk) {
        ArrayList filterList = new ArrayList(1);
        HashMap<String, String> filter = new HashMap<String, String>(6);
        filter.put("filter_left_bracket", "");
        filter.put("filter_column", pk);
        filter.put("filter_compare", "=");
        filter.put("filter_value", src);
        filter.put("filter_right_bracket", "");
        filter.put("filter_link", "");
        filterList.add(filter);
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("$is_filter", Boolean.TRUE);
        data.put("$filter_items", filterList);
        return data;
    }

    private String getSourcePrimaryKey() {
        long id = D.l((Object)this.rule.getRuleConfig().get("source_data_schema_id"));
        DynamicObject meta = MetaDataSchema.get(id);
        String pk = MetaUtil.getPrimaryKey(meta);
        if (pk == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\uff08%s\uff09\u4e0d\u662f\u5355\u5b57\u6bb5\u4e3b\u952e\uff0c\u4e0d\u652f\u6301\u503c\u8f6c\u6362\u89c4\u5219\u7684\u81ea\u52a8\u6570\u636e\u96c6\u6210\u3002", (String)"ValueConversionRuleProxy_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), meta.get("full_name")));
        }
        return pk;
    }

    @Override
    public boolean useDbCache() {
        return this.rule.useDbCache();
    }

    @Override
    public boolean useRedisCache() {
        return this.rule.useRedisCache();
    }
}

