/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.kdb;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.kdb.KConnection;
import kd.isc.iscb.platform.core.connector.kdb.KDTableInfo;
import kd.isc.iscb.platform.core.connector.self.DoDataAction;
import kd.isc.iscb.platform.core.connector.self.Util;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.misc.Pair;

public class KConnectionFactory
implements JdbcConnectionFactory {
    public JdbcConnectionWrapper create(DynamicObject cfg) {
        Util.setDynamicCfg((DynamicObject)cfg);
        return new JdbcConnectionWrapper((Connection)new KConnection(), (JdbcConnectionFactory)this, cfg, false);
    }

    public void test(ConnectionWrapper cn) {
    }

    public char getQuot() {
        return ' ';
    }

    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT TOP " + topN + " " + sql.substring("SELECT".length());
        }
        throw new IllegalArgumentException(sql);
    }

    public boolean supportsTransaction() {
        return false;
    }

    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        cn.ensureFluidControl();
        KConnection kcn = new KConnection();
        try {
            Response response = DoDataAction.execute((Connection)kcn, data, (Table)mainTable, entryTables, judgeFields, actions);
            return response;
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, (ConnectionWrapper)cn);
            throw e;
        }
        finally {
            DbUtil.close((Connection)kcn);
        }
    }

    public Map<String, Object> getTableInfo(JdbcConnectionWrapper cn, String fullname) {
        cn.ensureFluidControl();
        return KDTableInfo.get(fullname);
    }

    public Table getTable(JdbcConnectionWrapper cn, String fullname) {
        cn.ensureFluidControl();
        return KDTableInfo.getTable(fullname);
    }

    public Map<String, Index> getIndexInfo(JdbcConnectionWrapper cn, String fullname) {
        return KDTableInfo.getIndex(fullname);
    }

    public void classify(JdbcConnectionWrapper cn, Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        cn.ensureFluidControl();
        KConnection lcn = new KConnection();
        try {
            kd.isc.iscb.platform.core.connector.jdbc.Util.classify((Connection)lcn, (Table)table, rows, judgeFields, for_insert, for_update);
        }
        catch (Exception e) {
            ConnectionWrapper.rewrite((Throwable)e, (ConnectionWrapper)cn);
            throw e;
        }
        finally {
            DbUtil.close((Connection)lcn);
        }
    }

    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"KDB\u8fde\u63a5\u53ea\u652f\u6301\u540c\u6b65\u6570\u636e\u8868\u3002", (String)"KConnectionFactory_0", (String)"isc-iscb-connector-kdb", (Object[])new Object[0]));
    }
}

