/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.kdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.db.IndexInfo;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;

public class KDTableInfo {
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String COLUMN_NAME = "COLUMN_NAME";

    public static String getTableName(String fullname) {
        int i = fullname.indexOf(64);
        return i < 0 ? fullname : fullname.substring(0, i);
    }

    public static DBRoute getDbRoute(String fullname) {
        String dbKey = KDTableInfo.getDbString(fullname);
        return DBRoute.of((String)dbKey);
    }

    private static String getDbString(String fullname) {
        int i = fullname.indexOf(64);
        return i < 0 ? "ISCB" : fullname.substring(i + 1);
    }

    public static Map<String, Object> get(String fullname) {
        String table_name = KDTableInfo.getTableName(fullname);
        DBRoute dbRoute = KDTableInfo.getDbRoute(fullname);
        List info = DB.getFieldInfo((DBRoute)dbRoute, (String)table_name);
        List keys = DB.getPrimaryKeys((DBRoute)dbRoute, (String)table_name);
        HashMap<String, Object> tableInfo = new HashMap<String, Object>();
        tableInfo.put("name", table_name + '@' + KDTableInfo.getDbString(fullname));
        tableInfo.put("table_name", table_name + '@' + KDTableInfo.getDbString(fullname));
        tableInfo.put("type", "TABLE");
        tableInfo.put("full_name", table_name + '@' + KDTableInfo.getDbString(fullname));
        tableInfo.put("title", table_name);
        ArrayList properties = new ArrayList(info.size());
        tableInfo.put("properties", properties);
        tableInfo.put("events", Collections.emptyList());
        tableInfo.put("actions", Collections.emptyList());
        for (FieldInfo fieldInfo : info) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("name", fieldInfo.getFieldName());
            item.put("label", fieldInfo.getFieldName());
            item.put("data_type", DataTypeUtil.getDataType((int)fieldInfo.getJDBCDataType(), (int)fieldInfo.getDataPrecision(), (int)fieldInfo.getDataScale()));
            item.put("is_primary_key", keys.contains(fieldInfo.getFieldName()));
            item.put("is_nullable", fieldInfo.isNullable());
            properties.add(item);
        }
        return tableInfo;
    }

    public static Map<String, Index> getIndex(String fullname) {
        String table_name = KDTableInfo.getTableName(fullname);
        DBRoute dbRoute = KDTableInfo.getDbRoute(fullname);
        List indexInfo = DB.getIndexInfo((DBRoute)dbRoute, (String)table_name);
        HashMap<String, Index> indexs = new HashMap<String, Index>(indexInfo.size());
        for (IndexInfo info : indexInfo) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("TABLE_NAME", table_name + '@' + KDTableInfo.getDbString(fullname));
            map.put("INDEX_NAME", info.getIndexName());
            ArrayList columns = new ArrayList(1);
            for (IndexInfo.IndexFieldInfo fieldInfo : info.getIndexFieldInfo()) {
                HashMap<String, String> column = new HashMap<String, String>();
                column.put(COLUMN_NAME, fieldInfo.getFieldName());
                column.put(ASC_OR_DESC, fieldInfo.getSortType());
                columns.add(column);
            }
            map.put("COLUMNS", columns);
            Index index = new Index(map);
            indexs.put(info.getIndexName(), index);
        }
        return indexs;
    }

    public static Table getTable(String fullname) {
        String tableName = KDTableInfo.getTableName(fullname);
        DBRoute dbRoute = KDTableInfo.getDbRoute(fullname);
        List fieldInfos = DB.getFieldInfo((DBRoute)dbRoute, (String)tableName);
        ArrayList fields = new ArrayList(fieldInfos.size());
        for (FieldInfo info : fieldInfos) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(COLUMN_NAME, info.getFieldName());
            map.put("DATA_TYPE", info.getJDBCDataType());
            map.put("TYPE_NAME", DataTypeUtil.getDataType((int)info.getJDBCDataType(), (int)info.getDataPrecision(), (int)info.getDataScale()));
            map.put("IS_NULLABLE", info.isNullable());
            map.put("REMARKS", info.getFieldComment());
            map.put("COLUMN_SIZE", -1);
            map.put("DECIMAL_DIGITS", -1);
            fields.add(map);
        }
        return new Table(fullname, ' ', fields, DB.getPrimaryKeys((DBRoute)dbRoute, (String)tableName));
    }
}

