/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.kdb;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.DoubleType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.dataentity.resource.ResManager;

class KResultSetMetaData
implements ResultSetMetaData {
    private RowMeta meta;
    private Map<String, Integer> mapping;

    KResultSetMetaData(RowMeta meta) {
        this.meta = meta;
        this.mapping = new HashMap<String, Integer>(meta.getFieldCount() * 6);
        for (int i = 0; i < meta.getFieldCount(); ++i) {
            Integer column = i + 1;
            String alias = meta.getFieldAlias(i);
            String name = meta.getFieldName(i);
            if (name != null) {
                this.mapping.put(name, column);
                this.mapping.putIfAbsent(name.toUpperCase(), column);
                this.mapping.putIfAbsent(name.toLowerCase(), column);
            }
            if (alias == null) continue;
            this.mapping.putIfAbsent(alias, column);
            this.mapping.putIfAbsent(alias.toUpperCase(), column);
            this.mapping.putIfAbsent(alias.toLowerCase(), column);
        }
    }

    public int findField(String columnLabel) throws SQLException {
        Integer i = this.mapping.get(columnLabel);
        if (i != null) {
            return i;
        }
        throw new SQLException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08%s\uff09\u4e0d\u5b58\u5728\u3002", (String)"KResultSetMetaData_0", (String)"isc-iscb-connector-kdb", (Object[])new Object[0]), columnLabel));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.meta.getFieldCount();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.meta.isNullable(column - 1) ? 1 : 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.meta.getFieldName(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.meta.getFieldName(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        DataType type = this.meta.getDataType(column - 1);
        if (type instanceof StringType) {
            return -9;
        }
        if (type instanceof LongType) {
            return -5;
        }
        if (type instanceof BigDecimalType) {
            return 3;
        }
        if (type instanceof IntegerType) {
            return 4;
        }
        if (type instanceof TimestampType) {
            return 93;
        }
        if (type instanceof DateType) {
            return 91;
        }
        if (type instanceof DoubleType) {
            return 8;
        }
        if (type instanceof BooleanType) {
            return -7;
        }
        return 1111;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return -1;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return -1;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

