/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.client;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.client.MetaReader;
import kd.isc.iscb.util.connector.client.RemoteConnection;
import kd.isc.iscb.util.connector.client.RemoteContext;
import kd.isc.iscb.util.connector.client.RemoteInputStream;
import kd.isc.iscb.util.connector.client.RemoteOutputStream;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.AbstractInputStream;
import kd.isc.iscb.util.io.AbstractOutputStream;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Pair;

public class RemoteSystem {
    private static final String PROXY_USER = "proxy_user";
    private static final String JUDGE_FIELDS = "judgeFields";
    private static final String ENTITY = "entity";
    private static final String COMMAND = "command";

    public static Connection getConnection(RemoteContext ctx) {
        return new RemoteConnection(ctx);
    }

    public static List<String> getTables(RemoteContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_tables");
        Object result = ctx.invoke(params);
        if (result instanceof List) {
            return (List)result;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u662f\u671f\u671b\u7684\u8fd4\u56de\u7ed3\u679c\uff1a%s", (String)"RemoteSystem_1", (String)"isc-iscb-util", (Object[])new Object[0]), result));
    }

    public static Map<String, MetaType> getMetaList(RemoteContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_metas");
        Map result = (Map)ctx.invoke(params);
        if (result == null) {
            return Collections.emptyMap();
        }
        HashMap<String, MetaType> metas = new HashMap<String, MetaType>(result.size());
        for (Map.Entry e : result.entrySet()) {
            metas.put((String)e.getKey(), MetaType.valueOf((String)e.getValue()));
        }
        return metas;
    }

    public static Object test(RemoteContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "test");
        return ctx.invoke(params);
    }

    public static List<Map<String, Object>> getEntityInfo(RemoteContext ctx, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_entity_info");
        params.put("name", name);
        Object value = ctx.invoke(params);
        if (value instanceof Map) {
            return Collections.singletonList((Map)value);
        }
        return (List)value;
    }

    public static Map<String, Object> getEnumInfo(RemoteContext ctx, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_enum_info");
        params.put("name", name);
        return (Map)ctx.invoke(params);
    }

    public static Map<String, Object> getServiceInfo(RemoteContext ctx, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_service_info");
        params.put("name", name);
        return (Map)ctx.invoke(params);
    }

    public static List<Map<String, Object>> getServiceInfoX(RemoteContext ctx, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_service_infoX");
        params.put("name", name);
        return (List)ctx.invoke(params);
    }

    public static Map<String, Object> getTableInfo(RemoteContext ctx, String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_table_info");
        params.put("name", name);
        return (Map)ctx.invoke(params);
    }

    public static Table getTable(RemoteContext ctx, String table_name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_table");
        params.put("table_name", table_name);
        Map data = (Map)ctx.invoke(params);
        List fields = (List)data.get("fields");
        List primaryKeys = (List)data.get("primary_keys");
        Table table = new Table(table_name, RemoteSystem.getQuot(data.get("quot")), fields, primaryKeys);
        return table;
    }

    public static boolean isEventEnabled(RemoteContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "event_enabled");
        return D.x(ctx.invoke(params));
    }

    public static char getQuot(Object quot) {
        if (quot == null) {
            return '\"';
        }
        String s = quot.toString();
        if (s == null || s.length() == 0) {
            return '\"';
        }
        return s.charAt(0);
    }

    public static Map<String, Index> getIndexInfo(RemoteContext ctx, String table_name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_index_info");
        params.put("table_name", table_name);
        Map indices = (Map)ctx.invoke(params);
        HashMap<String, Index> data = new HashMap<String, Index>(indices.size());
        for (Map.Entry entry : indices.entrySet()) {
            data.put((String)entry.getKey(), new Index((Map)entry.getValue()));
        }
        return data;
    }

    public static void classify(RemoteContext ctx, Table table, List<Column> judgeFields, List<Map<String, Object>> rows, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        Map<String, Object> params = RemoteSystem.generateClassifyParams(table, rows, judgeFields, ctx);
        List exists = (List)ctx.invoke(params);
        RemoteSystem.classifyRows(exists, rows, for_insert, for_update);
    }

    private static void classifyRows(List<Boolean> exists, List<Map<String, Object>> rows, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        for (int i = 0; i < exists.size(); ++i) {
            if (exists.get(i).booleanValue()) {
                for_update.add(rows.get(i));
                continue;
            }
            for_insert.add(rows.get(i));
        }
    }

    private static Map<String, Object> generateClassifyParams(Table table, List<Map<String, Object>> rows, List<Column> judgeFields, RemoteContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "execute_classify");
        String sql = RemoteSystem.generateSQL(table, judgeFields);
        if (ctx.getVersion() < 2.0) {
            params.put("sql", sql);
        } else {
            String key = ctx.getKey();
            params.put("sql", Cipher.encrypt(sql, key));
        }
        params.put("types", RemoteSystem.getTypes(judgeFields));
        params.put("rows", RemoteSystem.getValues(rows, judgeFields));
        return params;
    }

    private static ArrayList<Object> getValues(List<Map<String, Object>> rows, List<Column> judgeFields) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map<String, Object> data : rows) {
            ArrayList<Object> row = new ArrayList<Object>(judgeFields.size());
            for (Column f : judgeFields) {
                Object value = data.get(f.getName());
                row.add(value);
            }
            values.add(row);
        }
        return values;
    }

    private static ArrayList<Integer> getTypes(List<Column> judgeFields) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (Column f : judgeFields) {
            types.add(f.getSqlType());
        }
        return types;
    }

    private static String generateSQL(Table table, List<Column> judgeFields) {
        StringBuilder sb = new StringBuilder();
        sb.append("select 1");
        sb.append(" from ");
        sb.append(table.getQuotedName());
        sb.append(" where ");
        for (int i = 0; i < judgeFields.size(); ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(judgeFields.get(i).getBinding()).append(" =? ");
        }
        String sql = sb.toString();
        return sql;
    }

    public static ObjectReader<Map<String, Object>> retrieveData(RemoteContext ctx, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "retrieve_data");
        params.put(ENTITY, entity);
        params.put("requires", requires);
        params.put("filter", filter);
        params.put("order_by", orderBy == null ? Collections.emptyList() : orderBy);
        Map result = (Map)ctx.invoke(params);
        return new MetaReader(ctx, result);
    }

    public static Response doBizAction(RemoteContext ctx, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "do_biz_action");
        params.put(ENTITY, entity);
        params.put("data", data);
        params.put(JUDGE_FIELDS, judgeFields);
        params.put("actions", actions);
        params.put(PROXY_USER, proxy_user);
        Map result = (Map)ctx.invoke(params);
        return new Response(D.s(result.get("id")), SaveDataType.valueOf(D.s(result.get("type"))), (Map)result.get("$entry_mapping"));
    }

    public static Response doBizActionWithParams(RemoteContext ctx, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, Map<String, Object> targetActionParams, String proxy_user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "do_biz_action");
        params.put(ENTITY, entity);
        params.put("data", data);
        params.put(JUDGE_FIELDS, judgeFields);
        params.put("actions", actions);
        params.put("targetActionParams", targetActionParams);
        params.put(PROXY_USER, proxy_user);
        Map result = (Map)ctx.invoke(params);
        return new Response(D.s(result.get("id")), SaveDataType.valueOf(D.s(result.get("type"))), (Map)result.get("$entry_mapping"));
    }

    public static List<Response> doBatchBizAction(RemoteContext ctx, String entity, List<Map<String, Object>> batchData, String pk, Map<String, List<String>> judgeFields, String action, String proxy_user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "do_batch_biz_action");
        params.put(ENTITY, entity);
        params.put("batchData", batchData);
        params.put("pk", pk);
        params.put(JUDGE_FIELDS, judgeFields);
        params.put("action", action);
        params.put(PROXY_USER, proxy_user);
        List result = (List)ctx.invoke(params);
        return RemoteSystem.castList2Responses(result);
    }

    public static List<Response> doBatchBizActionWithParams(RemoteContext ctx, String entity, List<Map<String, Object>> batchData, String pk, Map<String, List<String>> judgeFields, String action, Map<String, Object> targetActionParams, String proxy_user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "do_batch_biz_action");
        params.put(ENTITY, entity);
        params.put("batchData", batchData);
        params.put("pk", pk);
        params.put(JUDGE_FIELDS, judgeFields);
        params.put("action", action);
        params.put("targetActionParams", targetActionParams);
        params.put(PROXY_USER, proxy_user);
        List result = (List)ctx.invoke(params);
        return RemoteSystem.castList2Responses(result);
    }

    private static List<Response> castList2Responses(List<Map<String, Object>> results) {
        ArrayList<Response> list = new ArrayList<Response>(results.size());
        for (Map<String, Object> result : results) {
            String errorMessage = D.s(result.get("errorMessage"));
            Response response = errorMessage == null ? new Response(D.s(result.get("id")), SaveDataType.valueOf(D.s(result.get("type"))), (Map)result.get("$entry_mapping")) : new Response(D.s(result.get("id")), errorMessage);
            list.add(response);
        }
        return list;
    }

    public static Response doDataAction(RemoteContext ctx, Map<String, Object> data, String mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "do_data_action");
        params.put("data", data);
        params.put("mainTable", mainTable);
        params.put("entryTables", RemoteSystem.getMasterFields(entryTables));
        params.put(JUDGE_FIELDS, judgeFields);
        params.put("actions", actions);
        Map result = (Map)ctx.invoke(params);
        return new Response(D.s(result.get("id")), SaveDataType.valueOf(D.s(result.get("type"))), (Map)result.get("$entry_mapping"));
    }

    private static Map<String, Map<String, String>> getMasterFields(Map<String, Pair<Table, String>> entryTables) {
        HashMap<String, Map<String, String>> masterFields = new HashMap<String, Map<String, String>>(entryTables.size());
        for (Map.Entry<String, Pair<Table, String>> p : entryTables.entrySet()) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("table", p.getValue().getKey().getName());
            item.put("master", p.getValue().getValue());
            masterFields.put(p.getKey(), item);
        }
        return masterFields;
    }

    public static Response callDataHandler(RemoteContext ctx, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "call_data_handler");
        params.put("data", data);
        params.put("target_data_handler", targetDataHandler);
        params.put(JUDGE_FIELDS, judgeFields);
        params.put(PROXY_USER, proxy_user);
        Map result = (Map)ctx.invoke(params);
        return new Response(D.s(result.get("id")), SaveDataType.valueOf(D.s(result.get("type"))), (Map)result.get("$entry_mapping"));
    }

    public static Object callService(RemoteContext ctx, String service, Map<String, Object> args, String proxyUser) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "call_service");
        params.put("service", service);
        params.put("args", args);
        params.put(PROXY_USER, proxyUser);
        return ctx.invoke(params);
    }

    public static void attachEvents(RemoteContext ctx, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "attach_events");
        params.put("isc_hub", iscHub);
        params.put("trigger_type", (Object)type);
        params.put("trigger_id", triggerId);
        params.put(ENTITY, entity);
        params.put("events", events);
        params.put("requires", requires);
        ctx.invoke(params);
    }

    public static void detachEvents(RemoteContext ctx, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "detach_events");
        params.put("isc_hub", iscHub);
        params.put("trigger_type", (Object)type);
        params.put("trigger_id", triggerId);
        params.put(ENTITY, entity);
        ctx.invoke(params);
    }

    public static String topSQL(RemoteContext ctx, String sql, int topN) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "top_sql");
        params.put("top_n", topN);
        if (ctx.getVersion() < 2.0) {
            params.put("sql", sql);
            return D.s(ctx.invoke(params));
        }
        String key = ctx.getKey();
        params.put("sql", Cipher.encrypt(sql, key));
        String topSQL = D.s(ctx.invoke(params));
        return Cipher.decrypt(topSQL, ctx.getKey());
    }

    public static void rePushEventData(RemoteContext ctx, List<Object> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "repush_event_data");
        params.put("ids", ids);
        ctx.invoke(params);
    }

    public static String checkInitState(RemoteContext ctx, String encryptData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "check_init_state");
        params.put("encryptData", encryptData);
        return (String)ctx.invoke(params);
    }

    public static String checkInitState(RemoteContext ctx, String encryptData, String appId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "check_init_state");
        params.put("encryptData", encryptData);
        params.put("appId", appId);
        return (String)ctx.invoke(params);
    }

    public static String initEnv(RemoteContext ctx, String encryptData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "init_env");
        params.put("encryptData", encryptData);
        return (String)ctx.invoke(params);
    }

    public static String initEnv(RemoteContext ctx, String encryptData, String appId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "init_env");
        params.put("encryptData", encryptData);
        params.put("appId", appId);
        return (String)ctx.invoke(params);
    }

    public static void invokeCallbackHandler(RemoteContext ctx, String callbackHandler, Map<String, Object> response) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "invoke_callback_handler");
        params.put("callback_handler", callbackHandler);
        params.put("data", response);
        ctx.invoke(params);
    }

    public static void raiseEvent(RemoteContext ctx, String handler, Map<String, Object> data) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "raise_event");
        params.put("handler", handler);
        params.put("data", data);
        ctx.invoke(params);
    }

    public static AbstractInputStream getAttachmentReader(RemoteContext ctx, Map<String, Object> fileInfo) {
        return new RemoteInputStream(ctx, fileInfo);
    }

    public static AbstractOutputStream getAttachmentWriter(RemoteContext ctx, Map<String, Object> fileInfo, int blockSize) {
        return new RemoteOutputStream(ctx, fileInfo, blockSize);
    }

    public static boolean isAttachmentChanged(RemoteContext ctx, Map<String, Object> fileInfo, String md5Code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "is_attachment_changed");
        params.put("fileInfo", fileInfo);
        params.put("md5Code", md5Code);
        return D.x(ctx.invoke(params));
    }

    public static List<Map<String, Object>> retrieveAttachList(RemoteContext ctx, Map<String, Object> invokeParam) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "retrieve_attach_list");
        params.put("invokeParam", invokeParam);
        return (List)ctx.invoke(params);
    }

    public static int removeLogs(RemoteContext ctx, Map<String, Object> data) {
        HashMap<String, Object> params = new HashMap<String, Object>(data);
        params.put(COMMAND, "remove_log");
        return D.i(ctx.invoke(params));
    }

    public static String netSpeedTest(RemoteContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "net_speed_test");
        return (String)ctx.invoke(params);
    }

    public static List<String> invokeBotp(RemoteContext ctx, String botpNumber, List<String> idList, String proxyUser, Map<String, Object> extendInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "invoke_botp");
        params.put("botpNumber", botpNumber);
        params.put("idList", idList);
        params.put("proxyUser", proxyUser);
        params.put("extendInfo", extendInfo);
        return (List)ctx.invoke(params);
    }

    public static List<Map<String, Object>> initiateWorkflow(RemoteContext ctx, String entity, String operation, List<String> idList, String proxyUser, Map<String, Object> extendInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "initiate_workflow");
        params.put(ENTITY, entity);
        params.put("operation", operation);
        params.put("idList", idList);
        params.put("proxyUser", proxyUser);
        params.put("extendInfo", extendInfo);
        return (List)ctx.invoke(params);
    }

    public static List<Map<String, Object>> queryWorkflowState(RemoteContext ctx, String entity, String operation, List<String> idList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "query_workflow_state");
        params.put(ENTITY, entity);
        params.put("operation", operation);
        params.put("idList", idList);
        return (List)ctx.invoke(params);
    }

    public static List<Map<String, Object>> getWorkflowState(RemoteContext ctx, List<String> workflowInstanceIdList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_workflow_state");
        params.put("proc_inst_id_list", workflowInstanceIdList);
        return (List)ctx.invoke(params);
    }

    public static String getDbType(RemoteContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "get_database_type");
        return (String)ctx.invoke(params);
    }

    public static String undeploy(RemoteContext ctx, String iscHub, String data) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "remote_undeploy");
        params.put("isc_hub", iscHub);
        params.put("data", data);
        return (String)ctx.invoke(params);
    }

    public static Object callbackTest(RemoteContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(COMMAND, "$callback_test");
        return ctx.invoke(params);
    }
}

