/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.s;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.core.NativeFunction;

public class ExecuteCall
implements NativeFunction {
    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Connection cn = (Connection)args[0];
        String sql = D.s(args[1]);
        CallableStatement cal = null;
        try {
            cal = cn.prepareCall(sql);
            List values = (List)args[2];
            List<Integer> outIndexList = this.setParameter(cal, values);
            cal.execute();
            List<Object> list = this.getOutputs(cal, outIndexList);
            return list;
        }
        catch (SQLException e) {
            throw DatabaseError.SQL_UPDATE_FAILURE.wrap(e);
        }
        finally {
            DbUtil.close(cal);
        }
    }

    private List<Object> getOutputs(CallableStatement cal, List<Integer> outIndexList) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(outIndexList.size());
        for (int o : outIndexList) {
            result.add(cal.getObject(o));
        }
        return result;
    }

    private List<Integer> setParameter(CallableStatement cal, List<Map<String, Object>> values) throws SQLException {
        ArrayList<Integer> outIndexList = new ArrayList<Integer>();
        for (int i = 1; i <= values.size(); ++i) {
            Map<String, Object> paramInfo = values.get(i - 1);
            String mode = D.s(paramInfo.get("mode"));
            int sqlType = (Integer)paramInfo.get("type");
            this.checkSqlType(sqlType);
            Object value = paramInfo.get("value");
            if ("IN".equalsIgnoreCase(mode)) {
                this.innerSetParameter(cal, i, value, sqlType);
                continue;
            }
            if ("OUT".equalsIgnoreCase(mode)) {
                cal.registerOutParameter(i, sqlType);
                outIndexList.add(i);
                continue;
            }
            if ("INOUT".equalsIgnoreCase(mode)) {
                this.innerSetParameter(cal, i, value, sqlType);
                cal.registerOutParameter(i, sqlType);
                outIndexList.add(i);
                continue;
            }
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301Mode\u7c7b\u578b\u4e3a\uff1a%s\u7684\u53c2\u6570\u3002", (String)"ExecuteCall_3", (String)"isc-iscb-util", (Object[])new Object[0]), mode));
        }
        return outIndexList;
    }

    private void checkSqlType(int sqlType) {
        if (sqlType == 2012 || sqlType == 2009 || sqlType == 2000 || sqlType == 70) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301sqlType\u7c7b\u578b\u4e3a\uff1a%s\u7684\u53c2\u6570\u3002", (String)"ExecuteCall_4", (String)"isc-iscb-util", (Object[])new Object[0]), sqlType));
        }
    }

    private void innerSetParameter(CallableStatement cal, int i, Object value, int sqlType) {
        try {
            if (value == null) {
                cal.setNull(i, sqlType);
            } else {
                if (sqlType == 2004 && value instanceof byte[]) {
                    sqlType = -3;
                }
                cal.setObject(i, value, sqlType);
            }
        }
        catch (SQLException e) {
            throw DatabaseError.PARAMETER_ERROR.create(e, D.s(i), StringUtil.trim(D.s(value), 80));
        }
    }

    @Override
    public String name() {
        return "execute_call";
    }
}

