/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.server.CommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.Returns;
import kd.isc.iscb.util.connector.server.Util;
import kd.isc.iscb.util.connector.server.e.ExecuteBatch;
import kd.isc.iscb.util.connector.server.e.ExecuteClassify;
import kd.isc.iscb.util.connector.server.e.ExecuteQuery;
import kd.isc.iscb.util.connector.server.e.ExecuteUpdate;
import kd.isc.iscb.util.connector.server.e.GetIndexInfo;
import kd.isc.iscb.util.connector.server.e.GetMetaList;
import kd.isc.iscb.util.connector.server.e.GetTable;
import kd.isc.iscb.util.connector.server.e.GetTableInfo;
import kd.isc.iscb.util.connector.server.e.GetTables;
import kd.isc.iscb.util.connector.server.e.RemoveLog;
import kd.isc.iscb.util.connector.server.e.SavePartialContent;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Logger;

public class CommandDispatcher {
    private static final ThreadLocal<Boolean> is_running = new ThreadLocal();
    private static Logger logger;
    private static final Map<String, CommandExecutor> executors;

    public static boolean isRunning() {
        return D.x(is_running.get());
    }

    public static void setRunning(boolean running) {
        is_running.set(running);
    }

    public static Object execute(ConnectorContext ctx, Map<String, Object> params) {
        String command = D.s(params.get("command"));
        if ("get_result".equals(command)) {
            return CommandDispatcher.getResult(ctx, params);
        }
        if ("remove_result".equals(command)) {
            return CommandDispatcher.removeResult(ctx, params);
        }
        if ("net_speed_test".equals(command)) {
            return CommandDispatcher.newEmptyString();
        }
        if ("test".equals(command) && !executors.containsKey("test")) {
            return Boolean.TRUE;
        }
        if (command.startsWith("$") || CommandDispatcher.isSyncCommand(command)) {
            return CommandDispatcher.syncExecute(ctx, command, params);
        }
        return CommandDispatcher.asyncExecute(ctx, command, params);
    }

    private static boolean isSyncCommand(String command) {
        CommandExecutor commandExecutor = executors.get(command);
        return commandExecutor != null && commandExecutor.isSync();
    }

    private static String newEmptyString() {
        char[] chars = new char[524288];
        Arrays.fill(chars, 'O');
        return new String(chars);
    }

    private static Object removeResult(ConnectorContext ctx, Map<String, Object> params) {
        String id = D.s(params.get("$id"));
        ctx.removeResult(id);
        return Boolean.TRUE;
    }

    private static Object getResult(ConnectorContext ctx, Map<String, Object> params) {
        String id = D.s(params.get("$id"));
        Object result = ctx.getResult(id);
        return CommandDispatcher.handleResult(id, result);
    }

    private static Object asyncExecute(ConnectorContext ctx, String command, Map<String, Object> params) {
        Returns returns = ctx.createReturns(command);
        Util.asyncExecTask(CommandDispatcher.createTask(ctx, params, returns));
        Object result = returns.getResult();
        return CommandDispatcher.handleResult(returns.getId(), result);
    }

    private static Object syncExecute(ConnectorContext ctx, String command, Map<String, Object> params) {
        Returns returns = ctx.createReturns(command);
        CommandDispatcher.createTask(ctx, params, returns).run();
        Object result = returns.getResult();
        if (result != null) {
            return CommandDispatcher.handleResult(returns.getId(), result);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u547d\u4ee4\uff08%s\uff09\u540c\u6b65\u6267\u884c\uff0c\u4f46\u672a\u8fd4\u56de\u7ed3\u679c\u3002", (String)"CommandDispatcher_3", (String)"isc-iscb-util", (Object[])new Object[0]), command));
    }

    private static Object handleResult(String id, Object result) {
        if (result != null) {
            return result;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("$id", id);
        map.put("$keep-waiting", Boolean.TRUE);
        return map;
    }

    private static Runnable createTask(final ConnectorContext ctx, final Map<String, Object> params, final Returns returns) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    is_running.set(Boolean.TRUE);
                    CommandDispatcher.execute(ctx, params, returns);
                }
                catch (Throwable e) {
                    try {
                        returns.setResult(e);
                    }
                    catch (Throwable e2) {
                        logger.error("kd.isc.iscb.util.connector.server.Returns.setResult(Throwable)", e2);
                    }
                }
                finally {
                    is_running.remove();
                }
            }
        };
    }

    public static void setLogger(Logger logger) {
        CommandDispatcher.logger = logger;
    }

    private static void execute(ConnectorContext ctx, Map<String, Object> params, Returns returns) {
        String command = D.s(params.get("command"));
        CommandExecutor e = executors.get(command);
        if (e == null) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u547d\u4ee4\uff08%s\uff09\u672a\u5b9e\u73b0\uff01", (String)"CommandDispatcher_4", (String)"isc-iscb-util", (Object[])new Object[0]), command));
        }
        e.exec(ctx, params, returns);
    }

    public static void addExecutor(CommandExecutor e) {
        executors.put(e.getCommand(), e);
    }

    public static CommandExecutor getExecutor(String command) {
        return executors.get(command);
    }

    private void clearExecutors() {
        executors.clear();
    }

    static {
        executors = new ReadLockFreeMap<String, CommandExecutor>();
        CommandDispatcher.addExecutor(new ExecuteBatch());
        CommandDispatcher.addExecutor(new ExecuteClassify());
        CommandDispatcher.addExecutor(new ExecuteQuery());
        CommandDispatcher.addExecutor(new ExecuteUpdate());
        CommandDispatcher.addExecutor(new GetTable());
        CommandDispatcher.addExecutor(new GetTables());
        CommandDispatcher.addExecutor(new GetTableInfo());
        CommandDispatcher.addExecutor(new GetMetaList());
        CommandDispatcher.addExecutor(new GetIndexInfo());
        CommandDispatcher.addExecutor(new SavePartialContent());
        CommandDispatcher.addExecutor(new RemoveLog());
    }
}

