/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.server.CommandDispatcher;
import kd.isc.iscb.util.connector.server.CommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.ConnectorInfo;
import kd.isc.iscb.util.connector.server.ContextFactory;
import kd.isc.iscb.util.connector.server.ThreadDump;
import kd.isc.iscb.util.connector.server.Util;
import kd.isc.iscb.util.data.LocalCache;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.FileUtil;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.encoding.Hash;
import kd.isc.iscb.util.script.misc.log.Logger;
import kd.isc.iscb.util.script.misc.log.LoggerFactory;

public class ConnectionProxy
extends HttpServlet {
    public static final String ISC_SERVICE_URL = "/app/iscb/IscServiceDispatcher";
    private static String IERP_SERVER_URL = null;
    private static ContextFactory CONTEXT_FACTORY;
    private static ConnectorInfo CONNECTOR_INFO;
    private static volatile long last_time;
    private static final ThreadLocal<Long> invokeTime;
    private static final long serialVersionUID = 4224660522024527321L;
    private static String path;
    private static final Logger log;
    private static final LocalCache<String, Long> queryStringHashCache;

    public static void setIerpServerURL(String url) {
        IERP_SERVER_URL = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public static String getIerpServerURL() {
        if (IERP_SERVER_URL != null) {
            return IERP_SERVER_URL;
        }
        throw new IscBizException(ResManager.loadKDString((String)" \u8bf7\u4fee\u6539 connector.ini \u6dfb\u52a0\u82cd\u7a79\u670d\u52a1\u5668URL\uff08IERP_SERVER_URL\uff09\u914d\u7f6e\u9879\uff01", (String)"ConnectionProxy_0", (String)"isc-iscb-util", (Object[])new Object[0]));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getRequestURI().endsWith("/version")) {
            String version = "7.1";
            res.getOutputStream().write(version.getBytes(Charset.defaultCharset()));
        } else if (req.getRequestURI().endsWith("/connector_info")) {
            res.getOutputStream().write(CONNECTOR_INFO.getConnectorInfo().getBytes(Charset.defaultCharset()));
        } else if (req.getRequestURI().endsWith("/threads")) {
            ThreadDump.dump(res.getWriter());
        } else {
            long now = System.currentTimeMillis();
            res.setContentType("text/plain; charset=utf-8");
            if (last_time < now - 60000L) {
                last_time = now;
                ConnectionProxy.innerInit();
                res.getOutputStream().write("OK".getBytes(Charset.defaultCharset()));
            } else {
                res.getOutputStream().write("NOP".getBytes(Charset.defaultCharset()));
            }
        }
    }

    public static long getInvokeTime() {
        Long t = invokeTime.get();
        return t == null ? System.currentTimeMillis() : t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            invokeTime.set(System.currentTimeMillis());
            Map<String, Object> params = ConnectionProxy.readParams(req);
            String url = req.getRequestURL().toString();
            String queryString = req.getQueryString();
            ConnectorContext ctx = CONTEXT_FACTORY.parseURL(url, queryString, params);
            this.validateQueryString(queryString, params);
            Object data = CommandDispatcher.execute(ctx, params);
            res.getOutputStream().write(Json.toString(data).getBytes(D.UTF_8));
        }
        catch (Throwable e) {
            String json = Json.toString(e);
            res.getOutputStream().write(json.getBytes(D.UTF_8));
        }
        finally {
            invokeTime.remove();
        }
    }

    private void validateQueryString(String queryString, Map<String, Object> params) {
        String command = D.s(params.get("command"));
        if ("get_result".equals(command)) {
            return;
        }
        if ("remove_result".equals(command)) {
            return;
        }
        String hash = Hash.md5(queryString);
        if (queryStringHashCache.get(hash) == null) {
            queryStringHashCache.put(hash, System.currentTimeMillis());
            return;
        }
        String message = "suspected_net_attack, hash: " + hash + "; QueryString\uff1a" + queryString + "; params:" + StringUtil.trim(params, 800);
        log.warn(message);
        throw new IscBizException("suspected_net_attack, hash=" + hash);
    }

    public static Map<String, Object> readParams(HttpServletRequest req) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)req.getInputStream(), "UTF-8");){
            Map map = (Map)Json.toObject(reader);
            return map;
        }
    }

    public void init(ServletConfig config) throws ServletException {
        path = config.getServletContext().getRealPath("/WEB-INF/connector.ini");
        ConnectionProxy.innerInit();
    }

    public static synchronized void innerInit() {
        Map<String, String> map = Util.ini2map(FileUtil.read(path));
        IERP_SERVER_URL = map.remove("IERP_SERVER_URL");
        String className = map.remove("CONTEXT_FACTORY");
        try {
            ContextFactory factory = (ContextFactory)Class.forName(className).newInstance();
            for (CommandExecutor e : factory.init(map)) {
                CommandDispatcher.addExecutor(e);
            }
            CONTEXT_FACTORY = factory;
            CONNECTOR_INFO = new ConnectorInfo(factory.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    public static void clearQueryStringCacheBefore(long ts) {
        Pair<String, Long> p;
        while ((p = queryStringHashCache.first()) != null && p.getValue() < ts) {
            queryStringHashCache.remove(p.getKey());
        }
    }

    static {
        last_time = System.currentTimeMillis();
        invokeTime = new ThreadLocal();
        log = LoggerFactory.REF.get().getLogger(ConnectionProxy.class);
        int size = D.i((Object)System.getProperty("QUERY_STRING_CACHE_SIZE", "300000"));
        queryStringHashCache = new LocalCache(Math.max(5000, Math.min(size, 600000)));
    }
}

