/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.context.Context;

public class ThreadDump {
    public static String dump(Script filter) {
        int index = 0;
        StringBuilder out = new StringBuilder(32000);
        for (Object o : ThreadDump.getStackTraces()) {
            Map.Entry e = (Map.Entry)o;
            Thread thread = (Thread)e.getKey();
            Object value = filter.eval(ThreadDump.getThreadContext(e));
            if (!D.x(value)) continue;
            StackTraceElement[] entries = (StackTraceElement[])e.getValue();
            out.append(String.valueOf(++index)).append(". ");
            ThreadDump.outputStraceTrace(out, thread, entries);
            out.append("\r\n\r\n\r\n");
        }
        return out.toString();
    }

    public static String dump(Thread t) {
        StringBuilder out = new StringBuilder();
        out.append("Run at ").append(NetUtil.getServerId()).append("\r\n");
        ThreadDump.outputStraceTrace(out, t, t.getStackTrace());
        return out.toString();
    }

    private static void outputStraceTrace(StringBuilder out, Thread thread, StackTraceElement[] entries) {
        out.append(thread.getName());
        out.append("\r\nstate = ").append((Object)thread.getState());
        out.append("; is_alive = ").append(Boolean.toString(thread.isAlive()));
        out.append("; is_daemon = ").append(Boolean.toString(thread.isDaemon()));
        out.append("; priority = ").append(Integer.toString(thread.getPriority()));
        out.append("\r\n\r\n");
        for (StackTraceElement s : entries) {
            out.append("    at  ");
            out.append(s.getClassName());
            out.append('.');
            out.append(s.getMethodName());
            out.append('(');
            out.append(s.getFileName());
            out.append(':');
            out.append(String.valueOf(s.getLineNumber()));
            out.append(")\r\n");
        }
    }

    public static void dump(Writer out) throws IOException {
        int index = 0;
        out.append("<html><head></head><body><table width='100%' border='1' style='border-collapse:collapse'>");
        for (Object o : ThreadDump.getStackTraces()) {
            Map.Entry e = (Map.Entry)o;
            Thread thread = (Thread)e.getKey();
            out.append("<tr>");
            out.append("\t<td width='350'>");
            out.append(String.valueOf(++index)).append(". ");
            out.append(thread.getName());
            out.append("<br><br>&nbsp;state = ").append(thread.getState().toString());
            out.append("<br>&nbsp;is_alive = ").append(Boolean.toString(thread.isAlive()));
            out.append("<br>&nbsp;is_daemon = ").append(Boolean.toString(thread.isDaemon()));
            out.append("<br>&nbsp;priority = ").append(Integer.toString(thread.getPriority()));
            out.append("</td>");
            out.append("\t<td><pre>");
            for (StackTraceElement s : (StackTraceElement[])e.getValue()) {
                out.append(s.getClassName());
                out.append(".");
                out.append(s.getMethodName());
                out.append("(");
                out.append(s.getFileName());
                out.append(":");
                out.append(String.valueOf(s.getLineNumber()));
                out.append(")\r\n");
            }
            out.append("</pre></td>");
            out.append("</tr>");
        }
        out.append("</table></body></html>");
    }

    private static Object[] getStackTraces() {
        Object[] list = Thread.getAllStackTraces().entrySet().toArray();
        Arrays.sort(list, 0, list.length, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                Map.Entry t1 = (Map.Entry)a;
                Map.Entry t2 = (Map.Entry)b;
                return ((Thread)t1.getKey()).getName().compareTo(((Thread)t2.getKey()).getName());
            }
        });
        return list;
    }

    private static Context getThreadContext(final Map.Entry<Thread, StackTraceElement[]> e) {
        return new Context(){

            @Override
            public Object get(String property) {
                if ("name".equalsIgnoreCase(property)) {
                    return ((Thread)e.getKey()).getName();
                }
                if ("is_alive".equalsIgnoreCase(property)) {
                    return ((Thread)e.getKey()).isAlive();
                }
                if ("state".equalsIgnoreCase(property)) {
                    return ((Thread)e.getKey()).getState().toString();
                }
                if ("priority".equalsIgnoreCase(property)) {
                    return ((Thread)e.getKey()).getPriority();
                }
                if ("is_daemon".equalsIgnoreCase(property)) {
                    return ((Thread)e.getKey()).isDaemon();
                }
                return null;
            }

            @Override
            public boolean set(String property, Object value) {
                return false;
            }

            @Override
            public boolean contains(String property) {
                if ("name".equalsIgnoreCase(property)) {
                    return true;
                }
                if ("is_alive".equalsIgnoreCase(property)) {
                    return true;
                }
                if ("state".equalsIgnoreCase(property)) {
                    return true;
                }
                if ("priority".equalsIgnoreCase(property)) {
                    return true;
                }
                return "is_daemon".equalsIgnoreCase(property);
            }
        };
    }
}

