/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.script.misc.Const;

public enum BinaryEncoder {
    HEX{

        @Override
        public Object encode(byte[] bytes) {
            return Hex.encode(bytes);
        }
    }
    ,
    BASE64{

        @Override
        public Object encode(byte[] bytes) {
            return new String(Base64.encode(bytes));
        }
    }
    ,
    NONE{

        @Override
        public Object encode(byte[] bytes) {
            return bytes;
        }
    };

    public static final Const<Selector> IMPL;

    public abstract Object encode(byte[] var1);

    public static BinaryEncoder select(String algo) {
        if (algo == null) {
            return NONE;
        }
        if ("HEX".equalsIgnoreCase(algo)) {
            return HEX;
        }
        if ("BASE64".equalsIgnoreCase(algo)) {
            return BASE64;
        }
        return NONE;
    }

    static {
        IMPL = new Const<4>(new Selector(){

            @Override
            public BinaryEncoder select() {
                String algo = System.getProperty("ISC_BINARY_ENCODER_FOR_QUERY");
                return BinaryEncoder.select(algo);
            }
        });
    }

    public static interface Selector {
        public BinaryEncoder select();
    }
}

