/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.server.AbstractSqlCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.err.DatabaseError;

public class ExecuteBatch
extends AbstractSqlCommandExecutor {
    @Override
    public String getCommand() {
        return "execute_batch";
    }

    @Override
    protected ConnectorContext.Operation getOperation() {
        return ConnectorContext.Operation.WRITE;
    }

    @Override
    protected Object exec(ConnectorContext ctx, Connection cn, String sql, Map<String, Object> params) {
        try {
            if (!ctx.supportsTransaction()) {
                return ExecuteBatch.execute(cn, sql, params);
            }
            return this.executeWithTransaction(cn, sql, params);
        }
        catch (Exception e) {
            throw DatabaseError.SQL_UPDATE_FAILURE.wrap(e);
        }
    }

    private Object executeWithTransaction(Connection cn, String sql, Map<String, Object> params) throws SQLException {
        cn.setAutoCommit(false);
        try {
            int[] affected = ExecuteBatch.execute(cn, sql, params);
            cn.commit();
            int[] nArray = affected;
            return nArray;
        }
        catch (Throwable e) {
            cn.rollback();
            throw DatabaseError.SQL_UPDATE_FAILURE.wrap(e);
        }
        finally {
            cn.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] execute(Connection cn, String sql, Map<String, Object> params) throws SQLException {
        PreparedStatement ps = cn.prepareStatement(sql);
        try {
            ExecuteBatch.prepareBatches(params, ps);
            int[] nArray = ps.executeBatch();
            return nArray;
        }
        finally {
            DbUtil.close(ps);
        }
    }

    private static void prepareBatches(Map<String, Object> params, PreparedStatement ps) throws SQLException {
        List batches = (List)params.get("batches");
        for (Map batch : batches) {
            ExecuteBatch.addBatch(ps, batch);
        }
    }

    private static void addBatch(PreparedStatement ps, Map<String, Object> batch) throws SQLException {
        List values = (List)batch.get("values");
        List types = (List)batch.get("types");
        DbUtil.ensureParameters(values, types);
        DbUtil.setParameters(ps, values, types);
        ps.addBatch();
    }
}

