/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.e.DbInfo;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;

public class GetIndexInfo
extends AbstractCommandExecutor {
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String COLUMN_NAME = "COLUMN_NAME";

    @Override
    public String getCommand() {
        return "get_index_info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> exec(ConnectorContext ctx, Map<String, Object> params) {
        Connection cn = ctx.getConnection();
        try {
            Map<String, Object> map = GetIndexInfo.get(ctx, new DbInfo(cn), params);
            return map;
        }
        finally {
            ctx.dispose(cn);
        }
    }

    public static Map<String, Object> get(ConnectorContext ctx, DbInfo db, Map<String, Object> params) {
        String table_name = D.s(params.get("table_name"));
        if (ctx.isValid(table_name, ConnectorContext.Operation.WRITE) || ctx.isValid(table_name, ConnectorContext.Operation.READ)) {
            String catalog = db.getCatalog();
            String schema = db.getSchema();
            DatabaseMetaData meta = db.getMeta();
            try {
                return GetIndexInfo.innerGet(catalog, schema, meta, table_name);
            }
            catch (SQLException e) {
                throw DatabaseError.META_QUERY_FAILURE.wrap(e);
            }
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u65e0\u6743\u9650\u8bbf\u95ee\uff01", (String)"GetIndexInfo_0", (String)"isc-iscb-util", (Object[])new Object[0]));
    }

    public static Map<String, Object> get(Connection cn, String table_name) {
        try {
            String catalog = cn.getCatalog();
            String schema = DbUtil.getSchema(cn);
            DatabaseMetaData meta = cn.getMetaData();
            return GetIndexInfo.innerGet(catalog, schema, meta, table_name);
        }
        catch (SQLException e) {
            throw DatabaseError.META_QUERY_FAILURE.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> innerGet(String catalog, String schema, DatabaseMetaData meta, String table_name) throws SQLException {
        ResultSet rs = meta.getIndexInfo(catalog, schema, table_name, false, false);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            while (rs.next()) {
                HashMap<String, String> column;
                List columns;
                String indexName = D.s(rs.getObject("INDEX_NAME"));
                if (indexName == null) continue;
                String columnName = D.s(rs.getObject(COLUMN_NAME));
                String ascOrDesc = D.s(rs.getObject(ASC_OR_DESC));
                boolean isUnique = !D.x(rs.getObject("NON_UNIQUE"));
                String type = D.s(rs.getObject("TYPE"));
                HashMap<String, Object> index = (HashMap<String, Object>)map.get(indexName);
                if (index != null) {
                    columns = (List)index.get("COLUMNS");
                    column = new HashMap();
                    column.put(COLUMN_NAME, columnName);
                    column.put(ASC_OR_DESC, ascOrDesc);
                    columns.add(column);
                    continue;
                }
                columns = new ArrayList();
                column = new HashMap<String, String>();
                column.put(COLUMN_NAME, columnName);
                column.put(ASC_OR_DESC, ascOrDesc);
                columns.add(column);
                index = new HashMap<String, Object>();
                index.put("TABLE_NAME", table_name);
                index.put("INDEX_NAME", indexName);
                index.put("COLUMNS", columns);
                index.put("IS_UNIQUE", isUnique);
                index.put("TYPE", type);
                map.put(indexName, index);
            }
        }
        finally {
            DbUtil.close(rs);
        }
        return map;
    }
}

