/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.e.DbInfo;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;

public class GetTable
extends AbstractCommandExecutor {
    private static final String COLUMN_NAME = "COLUMN_NAME";

    @Override
    public String getCommand() {
        return "get_table";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object exec(ConnectorContext ctx, Map<String, Object> params) {
        Connection cn = ctx.getConnection();
        try {
            Map<String, Object> map = GetTable.getTableInfo(ctx, new DbInfo(cn), params);
            return map;
        }
        finally {
            ctx.dispose(cn);
        }
    }

    private static Map<String, Object> getTableInfo(ConnectorContext ctx, DbInfo db, Map<String, Object> params) {
        String table_name = D.s(params.get("table_name"));
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (ctx.isValid(table_name, ConnectorContext.Operation.WRITE) || ctx.isValid(table_name, ConnectorContext.Operation.READ)) {
            data.put("fields", GetTable.getFields(db, table_name));
            data.put("primary_keys", GetTable.getPrimaryKeys(db, table_name));
            data.put("name", table_name);
        } else {
            data.put("fields", Collections.emptyList());
            data.put("primary_keys", Collections.emptyList());
            data.put("label", "*" + table_name);
        }
        return data;
    }

    public static List<String> getPrimaryKeys(DbInfo db, String table_name) {
        DatabaseMetaData meta = db.getMeta();
        String catalog = db.getCatalog();
        String schema = db.getSchema();
        return GetTable.getPrimaryKeyFields(meta, table_name, catalog, schema);
    }

    public static List<String> getPrimaryKeyFields(DatabaseMetaData meta, String table_name, String catalog, String schema) {
        List<String> pks = GetTable.innerGetPrimaryKeys(meta, table_name, catalog, schema);
        if (pks.size() > 0) {
            return pks;
        }
        pks = GetTable.innerGetPrimaryKeys(meta, table_name.toUpperCase(), catalog, schema);
        if (pks.size() > 0) {
            return pks;
        }
        return GetTable.innerGetPrimaryKeys(meta, table_name.toLowerCase(), catalog, schema);
    }

    private static List<String> innerGetPrimaryKeys(DatabaseMetaData meta, String table_name, String catalog, String schema) {
        List<String> list;
        ResultSet rs = null;
        try {
            rs = meta.getPrimaryKeys(catalog, schema, table_name);
            list = GetTable.toPrimaryKeyList(rs);
        }
        catch (SQLException e) {
            try {
                throw DatabaseError.META_QUERY_FAILURE.wrap(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        return list;
    }

    public static List<Map<String, Object>> getFields(DbInfo db, String table_name) {
        String catalog = db.getCatalog();
        String schema = db.getSchema();
        DatabaseMetaData meta = db.getMeta();
        return GetTable.getTableFields(meta, table_name, catalog, schema);
    }

    public static List<Map<String, Object>> getTableFields(DatabaseMetaData meta, String table_name, String catalog, String schema) {
        List<Map<String, Object>> fields = GetTable.innerGetTableFields(meta, table_name, catalog, schema);
        if (fields.size() == 0) {
            fields = GetTable.innerGetTableFields(meta, table_name.toUpperCase(), catalog, schema);
        }
        if (fields.size() == 0) {
            fields = GetTable.innerGetTableFields(meta, table_name.toLowerCase(), catalog, schema);
        }
        return fields;
    }

    private static List<Map<String, Object>> innerGetTableFields(DatabaseMetaData meta, String table_name, String catalog, String schema) {
        List<Map<String, Object>> list;
        ResultSet rs = null;
        try {
            rs = meta.getColumns(catalog, schema, table_name, "%");
            list = GetTable.toFieldsList(rs, meta, table_name.toUpperCase());
        }
        catch (SQLException e) {
            try {
                throw DatabaseError.META_QUERY_FAILURE.wrap(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        return list;
    }

    private static List<Map<String, Object>> toFieldsList(ResultSet rs, DatabaseMetaData meta, String tableName) throws SQLException {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            if (!tableName.equalsIgnoreCase(rs.getString("TABLE_NAME"))) continue;
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(COLUMN_NAME, rs.getObject(COLUMN_NAME));
            item.put("IS_NULLABLE", rs.getObject("IS_NULLABLE"));
            Object type = rs.getObject("DATA_TYPE");
            item.put("DATA_TYPE", Column.handleSqlType(meta, D.i(type)));
            item.put("COLUMN_SIZE", rs.getObject("COLUMN_SIZE"));
            item.put("DECIMAL_DIGITS", rs.getObject("DECIMAL_DIGITS"));
            item.put("TYPE_NAME", rs.getObject("TYPE_NAME"));
            item.put("REMARKS", rs.getString("REMARKS"));
            fields.add(item);
        }
        return fields;
    }

    private static List<String> toPrimaryKeyList(ResultSet rs) throws SQLException {
        ArrayList<String> fields = new ArrayList<String>();
        while (rs.next()) {
            fields.add(rs.getString(COLUMN_NAME));
        }
        return fields;
    }
}

