/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;

public class DataRow
implements Map<String, Object> {
    private Schema schema;
    private Object[] _values;

    public DataRow(Schema schema, Object[] values) throws SQLException {
        this.schema = schema;
        this._values = new Object[schema.getFieldCount()];
        for (int i = 0; i < values.length; ++i) {
            Column field = schema.getField(i);
            this._values[i] = field.narrow(values[i]);
        }
    }

    public DataRow(Schema schema, ResultSet rs) throws SQLException {
        this.schema = schema;
        this._values = new Object[schema.getFieldCount()];
        for (int i = 0; i < this._values.length; ++i) {
            Column field = schema.getField(i);
            Object value = DbUtil.read(rs, i + 1);
            this._values[i] = field.narrow(value);
        }
    }

    public String getKey(int index) {
        return this.schema.getField(index).getName();
    }

    public boolean containsKey(String field) {
        return this.schema.hasField(field);
    }

    public Object getValue(String field) {
        int index = this.schema.getIndex(field);
        if (index >= 0) {
            return this._values[index];
        }
        return null;
    }

    public int getFieldCount() {
        return this.schema.getFieldCount();
    }

    public Object getValue(int index) {
        return this._values[index];
    }

    public void setValue(int index, Object value) {
        Column field = this.schema.getField(index);
        this._values[index] = field.narrow(value);
    }

    public Map<String, Object> toMap() {
        int count = this.schema.getFieldCount();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(count);
        int j = count;
        for (int i = 0; i < j; ++i) {
            String key = this.getKey(i);
            map.put(key, this.getValue(i));
        }
        return map;
    }

    @Override
    public int size() {
        return this.getFieldCount();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.schema.hasField(D.s(key));
    }

    public Schema getSchema() {
        return this.schema;
    }

    public int getFieldIndex(String field) {
        return this.schema.getIndex(field);
    }

    public Column getField(int index) {
        return this.schema.getField(index);
    }

    @Override
    public Object get(Object key) {
        String field = D.s(key);
        return this.getValue(field);
    }

    @Override
    public Set<String> keySet() {
        return new Set<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < DataRow.this.getFieldCount();
                    }

                    @Override
                    public String next() {
                        String key = DataRow.this.getKey(this.i);
                        ++this.i;
                        return key;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return DataRow.this.getFieldCount();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(String e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Collection<Object> values() {
        return Arrays.asList(this._values);
    }

    public String toString() {
        return this.toMap().toString();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new Set<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < DataRow.this.getFieldCount();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        Object value = DataRow.this.getValue(this.i);
                        String key = DataRow.this.getKey(this.i);
                        ++this.i;
                        return new Pair<String, Object>(key, value);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return DataRow.this.getFieldCount();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(Map.Entry<String, Object> e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<String, Object>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }
}

