/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.db;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.db.GeneralSchema;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.io.ObjectWriter;
import kd.isc.iscb.util.misc.Logger;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.Const;
import kd.isc.iscb.util.script.misc.log.DefaultLogger;

public class DbUtil {
    private static Logger logger = DbUtil.createDefaultLogger();
    private static ConcurrentHashMap<Class<?>, Boolean> lobFreeMethods = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<?>, Const<Method>> getSchemaMethods = new ConcurrentHashMap();

    public static Logger createDefaultLogger() {
        return new Logger(){

            @Override
            public void error(String message, Throwable e) {
                DefaultLogger.OUT.get().println(message + "\r\n" + StringUtil.toString(e));
            }
        };
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        DbUtil.logger = logger;
    }

    public static void close(Connection cn, boolean commit) {
        if (cn != null) {
            try {
                DbUtil.commit(cn, commit);
            }
            finally {
                DbUtil.innerClose(cn);
            }
        }
    }

    public static void close(Connection cn) {
        if (cn != null) {
            DbUtil.innerClose(cn);
        }
    }

    public static void close(Statement smt) {
        if (smt != null) {
            try {
                smt.close();
            }
            catch (Throwable t) {
                logger.error("kd.isc.iscb.util.db.DbUtil.close(Statement)", t);
            }
        }
    }

    public static void close(ObjectReader<?> reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Throwable t) {
                logger.error("kd.isc.iscb.util.db.DbUtil.close(ObjectReader)", t);
            }
        }
    }

    public static void close(ObjectWriter<?> writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Throwable t) {
                logger.error("kd.isc.iscb.util.db.DbUtil.close(ObjectWriter)", t);
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable t) {
                logger.error("kd.isc.iscb.util.db.DbUtil.close(ResultSet)", t);
            }
        }
    }

    public static void close(Connection cn, Statement smt) {
        DbUtil.close(smt);
        DbUtil.close(cn, true);
    }

    public static void close(Connection cn, ResultSet rs) {
        DbUtil.close(rs);
        DbUtil.close(cn, true);
    }

    public static void close(Statement smt, ResultSet rs) {
        DbUtil.close(rs);
        DbUtil.close(smt);
    }

    public static void close(Connection cn, Statement smt, ResultSet rs) {
        DbUtil.close(rs);
        DbUtil.close(smt);
        DbUtil.close(cn, true);
    }

    private static void innerClose(Connection cn) {
        try {
            cn.close();
        }
        catch (Throwable t) {
            logger.error("kd.isc.iscb.util.db.DbUtil.innerClose(Connection)", t);
        }
    }

    private static void commit(Connection cn, boolean commit) {
        try {
            if (commit && !cn.getAutoCommit()) {
                cn.commit();
            }
        }
        catch (SQLException e) {
            throw D.e(e);
        }
    }

    public static void setParameters(PreparedStatement smt, List<?> values, List<Integer> types) {
        int j = values.size();
        for (int i = 0; i < j; ++i) {
            Object value = values.get(i);
            int sqlType = types.get(i);
            DbUtil.setParameter(smt, i, value, sqlType);
        }
    }

    private static void setParameter(PreparedStatement smt, int index, Object value, int sqlType) {
        try {
            if (value == null) {
                smt.setNull(index + 1, sqlType);
            } else {
                if (sqlType == 2004 && value instanceof byte[]) {
                    sqlType = -3;
                }
                smt.setObject(index + 1, value, sqlType);
            }
        }
        catch (SQLException e) {
            throw DatabaseError.PARAMETER_ERROR.create(e, D.s(index + 1), StringUtil.trim(D.s(value), 80));
        }
    }

    public static Object executeScalar(Connection cn, String sql) {
        Object object;
        ResultSet rs = null;
        Statement smt = null;
        try {
            smt = cn.createStatement();
            rs = smt.executeQuery(sql);
            object = rs.next() ? DbUtil.read(rs, 1) : null;
        }
        catch (SQLException e) {
            try {
                throw DatabaseError.SQL_QUERY_FAILURE.wrap(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(smt, rs);
                throw throwable;
            }
        }
        DbUtil.close(smt, rs);
        return object;
    }

    public static Object executeScalar(Connection cn, String sql, List<Object> values, List<Integer> types) {
        Object object;
        ResultSet rs = null;
        PreparedStatement smt = null;
        try {
            smt = cn.prepareStatement(sql);
            DbUtil.setParameters(smt, values, types);
            smt.setFetchSize(1);
            rs = smt.executeQuery();
            object = rs.next() ? DbUtil.read(rs, 1) : null;
        }
        catch (SQLException e) {
            try {
                throw DatabaseError.SQL_QUERY_FAILURE.wrap(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(smt, rs);
                throw throwable;
            }
        }
        DbUtil.close(smt, rs);
        return object;
    }

    public static Object read(ResultSet rs, int column) {
        try {
            return DbUtil.innerRead(rs, column);
        }
        catch (SQLException e) {
            throw DatabaseError.RESULT_SET_READ_FAILURE.wrap(e);
        }
    }

    private static Object innerRead(ResultSet rs, int column) throws SQLException {
        Object v = rs.getObject(column);
        if (v instanceof Blob) {
            Blob lob = (Blob)v;
            v = lob.getBytes(1L, (int)lob.length());
            if (DbUtil.supportsFree(lob)) {
                lob.free();
            }
        } else {
            String className;
            if (v instanceof Clob) {
                return DbUtil.innerReadClob(v);
            }
            if (v != null && (className = v.getClass().getName()).startsWith("oracle.sql.TIMESTAMP")) {
                v = rs.getTimestamp(column);
            }
        }
        return v;
    }

    private static Object innerReadClob(Object v) throws SQLException {
        Clob lob = (Clob)v;
        try {
            v = lob.getSubString(DbUtil.getPos(v), (int)lob.length());
        }
        catch (Exception e) {
            v = lob.getSubString(1L, (int)lob.length());
        }
        finally {
            if (DbUtil.supportsFree(lob)) {
                lob.free();
            }
        }
        return v;
    }

    private static long getPos(Object v) {
        return "com.kingdee.jdbc.rowset.impl.SerialClob".equals(v.getClass().getName()) ? 0L : 1L;
    }

    protected static void clearMap() {
        lobFreeMethods.clear();
        getSchemaMethods.clear();
    }

    private static boolean supportsFree(Object o) {
        Class<?> c = o.getClass();
        if (DbUtil.isEasLobClass(c)) {
            return false;
        }
        Boolean isNormal = lobFreeMethods.get(c);
        if (isNormal != null) {
            return isNormal;
        }
        try {
            Method m = c.getMethod("free", new Class[0]);
            isNormal = (m.getModifiers() & 0x400) == 0;
        }
        catch (NoSuchMethodException e) {
            isNormal = Boolean.FALSE;
        }
        catch (SecurityException e) {
            isNormal = Boolean.FALSE;
        }
        lobFreeMethods.put(c, isNormal);
        return isNormal;
    }

    private static boolean isEasLobClass(Class<? extends Object> c) {
        return "net.sourceforge.jtds.jdbc.BlobImpl".equals(c.getName()) || "net.sourceforge.jtds.jdbc.ClobImpl".equals(c.getName());
    }

    public static String getSchema(Connection cn) {
        Const<Method> cm = getSchemaMethods.get(cn.getClass());
        if (cm == null) {
            cm = DbUtil.initMethodOfGetSchema(cn);
        }
        try {
            if (cm.isEmtpy()) {
                return null;
            }
            return (String)cm.get().invoke((Object)cn, new Object[0]);
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    private static Const<Method> initMethodOfGetSchema(Connection cn) {
        Const<Method> cm;
        Method m;
        try {
            m = cn.getClass().getMethod("getSchema", new Class[0]);
        }
        catch (Exception e) {
            throw D.e(e);
        }
        int mod = m.getModifiers();
        if (Modifier.isAbstract(mod) || !Modifier.isPublic(mod)) {
            cm = new Const();
        } else {
            m.setAccessible(true);
            cm = new Const<Method>(m);
        }
        getSchemaMethods.put(cn.getClass(), cm);
        return cm;
    }

    public static ObjectReader<DataRow> executeQuery(Connection cn, String sql, List<Object> values, List<Integer> types) {
        return DbUtil.executeQuery(cn, sql, values, types, 100);
    }

    public static List<DataRow> executeList(Connection cn, String sql, List<Object> values, List<Integer> types) {
        return DbUtil.toList(DbUtil.executeQuery(cn, sql, values, types, 100));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataRow executeRow(Connection cn, String sql) {
        List<Object> params = Collections.emptyList();
        List<Integer> types = Collections.emptyList();
        try (ObjectReader<DataRow> reader = DbUtil.executeQuery(cn, sql, params, types, 1);){
            DataRow dataRow = reader.read();
            return dataRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataRow executeRow(Connection cn, String sql, List<Object> values, List<Integer> types) {
        try (ObjectReader<DataRow> reader = DbUtil.executeQuery(cn, sql, values, types, 1);){
            DataRow dataRow = reader.read();
            return dataRow;
        }
    }

    public static Pair<ResultSet, Statement> executeQuery2(Connection cn, String sql, List<Object> values, List<Integer> types, int fetchSize) {
        PreparedStatement smt;
        try {
            smt = cn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw DatabaseError.PREPARED_STATEMENT_FAILURE.create(e, sql);
        }
        ResultSet rs = null;
        try {
            DbUtil.setFetchSize(smt, fetchSize);
            DbUtil.setParameters(smt, values, types);
            rs = smt.executeQuery();
            return new Pair<ResultSet, Statement>(rs, smt);
        }
        catch (Throwable e) {
            DbUtil.close(smt, rs);
            throw DatabaseError.SQL_QUERY_FAILURE.wrap(e);
        }
    }

    public static ObjectReader<DataRow> executeQuery(Connection cn, String sql, List<Object> values, List<Integer> types, int fetchSize) {
        Pair<ResultSet, Statement> p = DbUtil.executeQuery2(cn, sql, values, types, fetchSize);
        return DbUtil.asObjectReader(p.getA(), p.getB());
    }

    public static ObjectReader<DataRow> asObjectReader(ResultSet rs, Statement smt) {
        try {
            GeneralSchema schema = new GeneralSchema(rs.getMetaData());
            return new ResultReader(schema, rs, smt);
        }
        catch (Throwable e) {
            DbUtil.close(smt, rs);
            throw DatabaseError.RESULT_SET_READ_FAILURE.wrap(e);
        }
    }

    public static List<?> toList(ResultSet rs) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            DbUtil.fillList(rs, list);
            return list;
        }
        catch (SQLException e) {
            throw DatabaseError.RESULT_SET_READ_FAILURE.wrap(e);
        }
    }

    private static void fillList(ResultSet rs, List<Object> list) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        if (meta.getColumnCount() == 1) {
            while (rs.next()) {
                list.add(DbUtil.read(rs, 1));
            }
        } else {
            GeneralSchema schema = new GeneralSchema(meta);
            while (rs.next()) {
                list.add(new DataRow((Schema)schema, rs));
            }
        }
    }

    private static void setFetchSize(PreparedStatement smt, int fetchSize) throws SQLException {
        if (fetchSize > 0) {
            smt.setFetchSize(fetchSize);
        }
    }

    public static int executeUpdate(Connection cn, String sql) {
        Statement smt = null;
        try {
            smt = cn.createStatement();
            int n = smt.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            throw DatabaseError.SQL_UPDATE_FAILURE.wrap(e);
        }
        finally {
            DbUtil.close(smt);
        }
    }

    public static int executeUpdate(Connection cn, String sql, List<Object> values, List<Integer> types) {
        PreparedStatement smt = null;
        try {
            smt = cn.prepareStatement(sql);
            DbUtil.setParameters(smt, values, types);
            int n = smt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw DatabaseError.SQL_UPDATE_FAILURE.wrap(e);
        }
        finally {
            DbUtil.close(smt);
        }
    }

    public static long executeCount(Connection cn, String sql, List<Object> values, List<Integer> types) {
        int i = DbUtil.findSelect(sql);
        int j = DbUtil.findFrom(sql);
        int k = DbUtil.findOrderyBy(sql);
        String count_sql = sql.substring(i - 6, i) + " COUNT(*) as c " + sql.substring(j, k);
        Object count = DbUtil.executeScalar(cn, count_sql, values, types);
        return D.l(count);
    }

    private static int findSelect(String sql) {
        int index = DbUtil.findMinIndex(sql, "SELECT ", 0);
        if (index < 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230SELECT\u5173\u952e\u5b57. sql=%s", (String)"DbUtil_2", (String)"isc-iscb-util", (Object[])new Object[0]), sql));
        }
        return index + "SELECT".length();
    }

    private static int findOrderyBy(String sql) {
        int i = DbUtil.findMinIndex(sql, "ORDER BY ", 0);
        return i > 0 ? i : sql.length();
    }

    public static int findFrom(String sql) {
        int i = DbUtil.findFrom0(sql, 0);
        while (sql.charAt(i - 1) > ' ') {
            i = DbUtil.findFrom0(sql, i + 1);
        }
        return i;
    }

    private static int findFrom0(String sql, int start) {
        int j = DbUtil.findMinIndex(sql, "FROM ", start);
        if (j < 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230FROM\u5173\u952e\u5b57. sql=%s", (String)"DbUtil_3", (String)"isc-iscb-util", (Object[])new Object[0]), sql));
        }
        return j;
    }

    public static int findMinIndex(String sql, String key, int start) {
        int i = sql.indexOf(key.toUpperCase(), start);
        int j = sql.indexOf(key.toLowerCase(), start);
        if (i == -1) {
            return j;
        }
        if (j == -1) {
            return i;
        }
        return Math.min(i, j);
    }

    public static void ensureParameters(List<Object> values, List<Integer> types) {
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            DataType dt = DataTypeUtil.getDataType(types.get(i));
            Object forSave = dt.forSave(dt.narrow(value));
            values.set(i, forSave);
        }
    }

    public static List<DataRow> toList(ObjectReader<DataRow> reader) {
        try {
            ArrayList<DataRow> list = new ArrayList<DataRow>();
            DataRow row = reader.read();
            while (row != null) {
                list.add(row);
                row = reader.read();
            }
            ArrayList<DataRow> arrayList = list;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> toList(ObjectReader<DataRow> reader, String pk) {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            DataRow row = reader.read();
            while (row != null) {
                Map<String, Object> item = row.toMap();
                item.put("$id", item.get(pk));
                list.add(item);
                row = reader.read();
            }
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    public static int[] executeBatch(Connection cn, String sql, List<List<Object>> batch, List<Integer> types) {
        PreparedStatement ps = null;
        try {
            ps = cn.prepareStatement(sql);
            for (List<Object> values : batch) {
                DbUtil.setParameters(ps, values, types);
                ps.addBatch();
            }
            Object object = ps.executeBatch();
            return object;
        }
        catch (SQLException e) {
            throw DatabaseError.SQL_UPDATE_FAILURE.wrap(e);
        }
        finally {
            DbUtil.close(ps);
        }
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Throwable t) {
                logger.error("kd.isc.iscb.util.db.DbUtil.close(InputStream)", t);
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Throwable t) {
                logger.error("kd.isc.iscb.util.db.DbUtil.close(OutputStream)", t);
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Throwable t) {
                logger.error("kd.isc.iscb.util.db.DbUtil.close(Reader)", t);
            }
        }
    }

    public static int calcBytes(DataRow row) {
        int size = 0;
        for (int i = 0; i < row.getFieldCount(); ++i) {
            size += DbUtil.calcBytes(row.getKey(i), row.getValue(i));
        }
        return size;
    }

    public static int calcBytes(String name, Object value) {
        if (value == null) {
            return name.length() + 8;
        }
        if (value instanceof String) {
            return name.length() + ((String)value).length() * 2 + 16;
        }
        if (value instanceof byte[]) {
            return name.length() + ((byte[])value).length + 8;
        }
        return name.length() + 16;
    }

    public static long getObjectSize(Object value) {
        if (value == null) {
            return 4L;
        }
        if (value instanceof DataRow) {
            return DbUtil.calcBytes((DataRow)value);
        }
        if (value instanceof Collection) {
            return DbUtil.calcBytes((Collection)value);
        }
        if (value instanceof Map) {
            return DbUtil.calcBytes((Map)value);
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() * 2 + 8;
        }
        if (value instanceof byte[]) {
            return ((byte[])value).length + 8;
        }
        if (value instanceof Object[]) {
            return DbUtil.calcBytes((Object[])value);
        }
        if (value.getClass().isArray()) {
            return DbUtil.calcOtherArraySize(value);
        }
        return 16L;
    }

    private static long calcOtherArraySize(Object array) {
        long total = 16L;
        int j = Array.getLength(array);
        for (int i = 0; i < j; ++i) {
            Object value = Array.get(array, i);
            total += DbUtil.getObjectSize(value);
        }
        return total;
    }

    private static long calcBytes(Map<?, ?> m) {
        long total = 16L;
        for (Map.Entry<?, ?> e : m.entrySet()) {
            total += DbUtil.getObjectSize(e.getKey());
            total += DbUtil.getObjectSize(e.getValue());
        }
        return total;
    }

    private static long calcBytes(Collection<?> c) {
        long total = 16L;
        for (Object e : c) {
            total += DbUtil.getObjectSize(e);
        }
        return total;
    }

    private static long calcBytes(Object[] c) {
        long total = 16L;
        for (Object e : c) {
            total += DbUtil.getObjectSize(e);
        }
        return total;
    }

    private static final class ResultReader
    implements ObjectReader<DataRow> {
        private final GeneralSchema fschema;
        private final ResultSet frs;
        private final Statement fsmt;

        private ResultReader(GeneralSchema fschema, ResultSet frs, Statement fsmt) {
            this.fschema = fschema;
            this.frs = frs;
            this.fsmt = fsmt;
        }

        @Override
        public DataRow read() {
            try {
                if (this.frs.next()) {
                    return new DataRow((Schema)this.fschema, this.frs);
                }
                return null;
            }
            catch (Exception e) {
                throw DatabaseError.RESULT_SET_READ_FAILURE.wrap(e);
            }
        }

        @Override
        public int getTotalCount() {
            return -1;
        }

        @Override
        public void close() {
            DbUtil.close(this.fsmt, this.frs);
        }
    }
}

