/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.db.type;

import java.sql.Connection;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.Table;

public class OracleDbType
implements DbType {
    @Override
    public String getDataType(Column c) {
        int length = c.getPrecision();
        switch (c.getOrginalSqlType()) {
            case -6: {
                return "NUMBER(3)";
            }
            case 5: {
                return "NUMBER(5)";
            }
            case 4: {
                return "NUMBER(10)";
            }
            case -5: {
                return "NUMBER(20)";
            }
            case -4: 
            case 2004: {
                return "BLOB";
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return "NCLOB";
            }
            case -3: 
            case -2: {
                if (length <= 4000) {
                    return "RAW(" + length + ")";
                }
                return "BLOB";
            }
            case 12: {
                if (length <= 4000) {
                    return "VARCHAR2(" + length + " char)";
                }
                return "CLOB";
            }
            case -9: {
                if (length <= 4000) {
                    return "NVARCHAR2(" + length + ")";
                }
                return "NCLOB";
            }
            case 1: {
                return "CHAR(" + length + " char)";
            }
            case -15: {
                return "NCHAR(" + length + ")";
            }
            case -7: {
                return "VARCHAR2(10)";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIMESTAMP";
            }
            case 2: 
            case 3: {
                return "NUMBER(" + length + "," + c.getScale() + ")";
            }
            case 6: 
            case 7: 
            case 8: {
                return "FLOAT";
            }
            case -8: {
                return "ROWID";
            }
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6570\u636e\u7c7b\u578b\uff08%s\uff09", (String)"OracleDbType_1", (String)"isc-iscb-util", (Object[])new Object[0]), c.getOrginalSqlType()));
    }

    @Override
    public String qualifyTableName(String tableName) {
        return tableName.toUpperCase(Locale.ENGLISH);
    }

    @Override
    public String qualifyColumnName(String columnName) {
        return columnName.toUpperCase(Locale.ENGLISH);
    }

    @Override
    public char getQuotChar() {
        return '\"';
    }

    @Override
    public void setBigQuery(Connection src) {
    }

    @Override
    public void unsetBigQuery(Connection src) {
    }

    @Override
    public String emtpyTableTestSQL(Table table) {
        return "SELECT 1 FROM " + table.getQuotedName() + " WHERE ROWNUM <= 1";
    }
}

