/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.dt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.CollectionDataType;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.misc.Json;

public abstract class AbstractCollectionDataType
implements CollectionDataType {
    private DataType elementType;

    protected AbstractCollectionDataType(DataType elementType) {
        if (elementType instanceof CollectionDataType) {
            throw new UnsupportedOperationException("Element type is collection.");
        }
        this.elementType = elementType;
    }

    @Override
    public final DataType getElementType() {
        return this.elementType;
    }

    @Override
    public final Object narrow(Object outerValue) {
        String s;
        if (outerValue == null) {
            return null;
        }
        if (outerValue instanceof String && (s = (String)outerValue).startsWith("json:")) {
            outerValue = Json.toObject((String)outerValue);
        }
        Collection<Object> list = this.newCollection();
        if (outerValue instanceof Iterable) {
            Iterator it = ((Iterable)outerValue).iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
        } else if (outerValue instanceof Object[]) {
            for (Object v : (Object[])outerValue) {
                list.add(v);
            }
        } else {
            Object value = this.getElementType().narrow(outerValue);
            if (value != null) {
                list.add(value);
            }
        }
        return list;
    }

    @Override
    public Object forJson(Object innerValue) {
        if (innerValue == null) {
            return null;
        }
        Collection c = (Collection)innerValue;
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(this.elementType.forJson(o));
        }
        return list;
    }

    protected abstract Collection<Object> newCollection();

    @Override
    public Object forSave(Object innerValue) {
        if (innerValue == null) {
            return null;
        }
        Collection c = (Collection)innerValue;
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(this.elementType.forSave(o));
        }
        return "json:" + Json.toString(list);
    }

    public String toString() {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u5b50\u7c7b\u5e94\u8be5\u8986\u76d6toString()\u65b9\u6cd5\uff01", (String)"AbstractCollectionDataType_0", (String)"isc-iscb-util", (Object[])new Object[0]));
    }
}

