/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.dt.i;

import kd.isc.iscb.util.dt.i.AbstractSimpleDataType;
import kd.isc.iscb.util.dt.i.Hex;

public final class BinaryType
extends AbstractSimpleDataType {
    private int max_length;

    public BinaryType(int max_length) {
        this.max_length = max_length;
    }

    @Override
    public Object narrow(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return Hex.encode((byte[])value);
        }
        String s = value.toString().trim();
        return s.length() == 0 ? null : s;
    }

    @Override
    public Object forSave(Object innerValue) {
        if (innerValue == null) {
            return null;
        }
        return Hex.decode((String)innerValue);
    }

    public int getMaxLength() {
        return this.max_length;
    }

    public String toString() {
        return this.max_length <= 0 ? "blob" : "varbinary(" + this.max_length + ")";
    }
}

