/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.c.trans;

import java.util.ArrayList;
import java.util.List;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.c.trans.AbstractTransit;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.core.i.model.TransitionImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;

public class LazyChoice
extends AbstractTransit {
    private static final String DEFERRED_TRANSITIONS = "DEFERRED_TRANSITIONS";
    public static final Command CMD = new LazyChoice();

    private LazyChoice() {
        super(20000000);
    }

    @Override
    List<TransitionImpl> findNext(ExecutionImpl e) {
        List<TransitionImpl> trans = LazyChoice.getDeferredChoices(e);
        if (trans == null || trans.size() == 0) {
            return null;
        }
        return trans;
    }

    private static List<TransitionImpl> getDeferredChoices(ExecutionImpl e) {
        List choices = (List)e.getProperty(DEFERRED_TRANSITIONS);
        if (choices == null) {
            return null;
        }
        ArrayList<TransitionImpl> trans = new ArrayList<TransitionImpl>(choices.size());
        FlowImpl flow = e.getDefine().getFlow();
        for (String id : choices) {
            TransitionImpl tran = flow.getTransition(id);
            trans.add(tran);
        }
        return trans;
    }

    public static void setDeferredChoice(ExecutionImpl e, String[] trans) {
        if (trans == null || trans.length == 0) {
            throw new NullPointerException("Not set transitions!");
        }
        LazyChoice.verifyTransitionIds(e, trans);
        List<String> list = LazyChoice.array2list(trans);
        e.setProperty(DEFERRED_TRANSITIONS, list);
    }

    private static List<String> array2list(String[] trans) {
        ArrayList<String> list = new ArrayList<String>(trans.length);
        for (String id : trans) {
            list.add(id);
        }
        return list;
    }

    private static void verifyTransitionIds(ExecutionImpl e, String[] trans) {
        NodeImpl node = (NodeImpl)e.getDefine();
        FlowImpl flow = node.getFlow();
        for (String id : trans) {
            TransitionImpl tran = flow.getTransition(id);
            if (tran == null) {
                throw new IscBizException("Transition '" + id + "' doesn't exist!");
            }
            if (tran.getSource() == node) continue;
            throw new IscBizException("Transition '" + id + "' doesn't come from '" + e + "'!");
        }
    }
}

