/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.model;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.ProcessElement;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.script.context.Context;

public abstract class AbstractElement
implements ProcessElement,
Context {
    private String id;
    private String title;
    private FlowImpl flow;
    private Map<String, Object> attributes;

    AbstractElement(FlowImpl flow, String id, String title) {
        this.id = id;
        this.title = title;
        this.flow = flow;
        flow.register(this);
    }

    AbstractElement(String id, String title) {
        this.id = id;
        this.title = title;
        this.flow = (FlowImpl)this;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final FlowImpl getFlow() {
        return this.flow;
    }

    @Override
    public final String getTitle() {
        return this.title;
    }

    @Override
    public Object get(String property) {
        Object value = this.getAttribute(property);
        if (value != null) {
            return value;
        }
        if ("id".equals(property)) {
            return this.getId();
        }
        if ("title".equals(property)) {
            return this.getTitle();
        }
        if ("flow".equals(property)) {
            return this.getFlow();
        }
        return null;
    }

    @Override
    public boolean set(String property, Object value) {
        return false;
    }

    @Override
    public boolean contains(String property) {
        if (this.getAttribute(property) != null) {
            return true;
        }
        if ("id".equals(property)) {
            return true;
        }
        if ("title".equals(property)) {
            return true;
        }
        return "flow".equals(property);
    }

    @Override
    public synchronized void setAttribute(String name, Object value) {
        Object old;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        if ((old = this.attributes.put(name, value)) != null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5c5e\u6027 %s \u88ab\u6539\u5199!", (String)"AbstractElement_2", (String)"isc-iscb-util", (Object[])new Object[0]), name));
        }
    }

    @Override
    public synchronized Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public synchronized Map<String, Object> getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.attributes != null) {
            attributes.putAll(this.attributes);
        }
        return attributes;
    }

    public final String toString() {
        return this.title == null || this.title.length() == 0 ? this.id : this.title;
    }

    abstract void compile();

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.flow.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractElement other = (AbstractElement)obj;
        if (!this.flow.equals(other.flow)) {
            return false;
        }
        return this.id.equals(other.id);
    }
}

