/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.pattern;

import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.CollectionDataType;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.DataTypes;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.i.c.composite.StartSubNodes4MultiInst;
import kd.isc.iscb.util.flow.core.i.model.GroupImpl;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.core.i.model.Output;
import kd.isc.iscb.util.flow.core.i.model.Pattern;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;

public class ChildrenMultiInstance
extends Pattern {
    public static final String NAME = "children-multi-instance";
    private NodeImpl node;
    private GroupImpl scope;
    private VariableImpl splitVar;
    private VariableImpl splitShadow;
    private VariableImpl[] returnVars;
    private VariableImpl[] returnShadows;
    private VariableImpl[] paramVars;
    private String splitVarName;
    private String innerSplitVarName;
    private String[] returnVarNames;
    private String[] paramVarNames;
    private VariableImpl countVar;

    public ChildrenMultiInstance(NodeImpl node, String splitVar, String[] paramVars, String[] returnVars) {
        this(node, splitVar, splitVar, paramVars, returnVars);
    }

    public ChildrenMultiInstance(NodeImpl node, String splitVar, String innerSplitVar, String[] paramVars, String[] returnVars) {
        super(700, "CALL_CHILDREN", "CALL_CHILDREN");
        this.node = node;
        this.splitVarName = splitVar;
        this.innerSplitVarName = innerSplitVar;
        this.returnVarNames = returnVars == null ? new String[]{} : returnVars;
        this.paramVarNames = paramVars == null ? new String[]{} : paramVars;
        this.createScopeAndSetWR();
        this.createCountVar();
    }

    private void createScopeAndSetWR() {
        this.createGroupAndSplitVarShadow();
        this.createReturnVarShadow(this.scope);
    }

    private void createCountVar() {
        String name = "$count";
        String id = "$count@" + this.node.getId();
        this.countVar = this.node.addVariable(id, "$count", "$count", DataTypes.INTEGER);
    }

    private void createReturnVarShadow(GroupImpl scope) {
        this.returnShadows = new VariableImpl[this.returnVarNames.length];
        for (int i = 0; i < this.returnVarNames.length; ++i) {
            VariableImpl r;
            if (this.returnVarNames[i].equals(this.splitVarName)) {
                this.returnShadows[i] = this.splitShadow;
                continue;
            }
            String name = this.returnVarNames[i];
            String id = name + "@" + this.node.getId();
            this.returnShadows[i] = r = scope.addVariable(id, name, name, null);
        }
    }

    private void createGroupAndSplitVarShadow() {
        this.scope = new GroupImpl(this.node.getFlow(), "sg-" + this.node.getId(), "children-split:" + this.node);
        String id = this.splitVarName + "@" + this.node.getId();
        String name = this.innerSplitVarName;
        this.splitShadow = this.scope.addVariable(id, name, name, null);
    }

    private void checkAndSetVariables(NodeImpl node) {
        this.splitVar = node.retrieveVariable(this.splitVarName);
        if (!(this.splitVar.getType() instanceof CollectionDataType)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%1$s\uff09\u7684\u4e3b\u53d8\u91cf\uff08%2$s\uff09\u7c7b\u578b\u4e0d\u662f\u591a\u503c\u53d8\u91cf\uff01", (String)"ChildrenMultiInstance_5", (String)"isc-iscb-util", (Object[])new Object[0]), node, this.splitVar));
        }
        this.setReturnVars(node);
        this.setSplitShadowType();
        this.setParamVars(node);
    }

    private void setParamVars(NodeImpl node) {
        this.paramVars = new VariableImpl[this.paramVarNames.length];
        for (int i = 0; i < this.paramVars.length; ++i) {
            this.paramVars[i] = node.retrieveVariable(this.paramVarNames[i]);
        }
    }

    private void setSplitShadowType() {
        if (this.splitShadow.getType() == null) {
            CollectionDataType c = (CollectionDataType)this.splitVar.getType();
            this.splitShadow.setType(c.getElementType());
        }
    }

    private void setReturnVars(NodeImpl node) {
        this.returnVars = new VariableImpl[this.returnVarNames.length];
        for (int i = 0; i < this.returnVars.length; ++i) {
            this.returnVars[i] = node.retrieveVariable(this.returnVarNames[i]);
            this.returnVars[i].register(this.countVar);
            DataType type = this.returnVars[i].getType();
            if (type instanceof CollectionDataType) {
                type = ((CollectionDataType)type).getElementType();
            }
            this.returnShadows[i].setType(type);
        }
    }

    @Override
    public void apply(NodeImpl node) {
        if (node.getChildrenCount() == 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9(%s)\u6ca1\u6709\u5b50\u8282\u70b9\uff01", (String)"ChildrenMultiInstance_6", (String)"isc-iscb-util", (Object[])new Object[0]), node));
        }
        this.checkAndSetVariables(node);
        this.createOutput(node);
        this.childrenJoinGroup(node);
        this.insertCommand(node);
    }

    private void insertCommand(NodeImpl node) {
        node.insert(new StartSubNodes4MultiInst(node, this.splitVar, this.splitShadow, this.paramVars, this.returnVars, this.countVar));
    }

    private void childrenJoinGroup(NodeImpl node) {
        for (NodeImpl child : node.getChildren()) {
            child.join(this.scope);
        }
    }

    private void createOutput(NodeImpl node) {
        Output output = new Output(this.returnShadows, this.returnVars);
        node.setOutput(output);
    }
}

