/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.runtime;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.DataArea;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.core.i.model.Output;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;
import kd.isc.iscb.util.flow.core.i.runtime.PropertyContainerImpl;
import kd.isc.iscb.util.flow.core.i.runtime.RuntimeImpl;
import kd.isc.iscb.util.script.misc.Consts;

public final class DataAreaImpl
extends PropertyContainerImpl
implements DataArea {
    private String id;
    private DataAreaImpl parent;
    private FlowImpl flow;
    private RuntimeImpl runtime;
    private ExecutionImpl host;
    private Object[] values;
    private LinkedList<ExecutionImpl> executions = new LinkedList();
    private ArrayList<DataAreaImpl> children;
    private boolean canceled = false;

    private DataAreaImpl() {
    }

    static DataAreaImpl fromJson(HashMap<String, FlowImpl> flows, RuntimeImpl runtime, Map<String, Object> e, DataAreaImpl parent) {
        String id = (String)e.get("flow");
        FlowImpl flow = flows.get(id);
        if (flow == null) {
            throw new IscBizException("FlowDef (" + id + ") doesn't exist!");
        }
        DataAreaImpl da = new DataAreaImpl();
        da.id = (String)e.get("id");
        da.parent = parent;
        da.flow = flow;
        da.runtime = runtime;
        da.canceled = Boolean.parseBoolean((String)e.get("canceled"));
        DataAreaImpl.restoreHost(runtime, e, da);
        DataAreaImpl.restoreExecutions(flows, runtime, e, da);
        DataAreaImpl.restoreValues(runtime, e, flow, da);
        DataAreaImpl.restoreChildren(flows, runtime, e, da);
        da.restoreProperties(e);
        return da;
    }

    private static void restoreChildren(HashMap<String, FlowImpl> flows, RuntimeImpl runtime, Map<String, Object> e, DataAreaImpl da) {
        Collection children = (Collection)e.get("children");
        if (children == null || children.size() == 0) {
            return;
        }
        da.children = new ArrayList();
        for (Map child : children) {
            DataAreaImpl c = DataAreaImpl.fromJson(flows, runtime, child, da);
            da.children.add(c);
        }
    }

    private static void restoreValues(RuntimeImpl runtime, Map<String, Object> e, FlowImpl flow, DataAreaImpl da) {
        int count = flow.variableCount();
        da.values = new Object[count];
        Collection values = (Collection)e.get("values");
        if (da.values.length != values.size()) {
            throw new IscBizException("Variables' number dismatches!");
        }
        int i = 0;
        for (Object v : values) {
            VariableImpl var = flow.getVariable(i);
            if (!var.isTransient()) {
                DataType type = var.getType();
                da.values[i] = type.narrow(v);
            }
            ++i;
        }
    }

    private static void restoreExecutions(HashMap<String, FlowImpl> flows, RuntimeImpl runtime, Map<String, Object> e, DataAreaImpl da) {
        Collection executions = (Collection)e.get("executions");
        if (executions == null) {
            return;
        }
        for (Map execution : executions) {
            ExecutionImpl tmp = ExecutionImpl.fromJson(flows, execution, runtime, da);
            da.executions.add(tmp);
        }
    }

    private static void restoreHost(RuntimeImpl runtime, Map<String, Object> e, DataAreaImpl da) {
        String host = (String)e.get("host");
        if (host != null && host.length() > 0) {
            da.host = runtime.getExecution(host);
            if (da.host == null) {
                throw new IscBizException("Execution (" + host + ") doesn't exist!");
            }
        }
    }

    void toJson(HashMap<String, Object> e) {
        e.put("id", this.id);
        e.put("host", this.host == null ? "" : this.host.getId());
        e.put("flow", this.flow.getId());
        e.put("crc", this.flow.getCrc());
        e.put("canceled", String.valueOf(this.canceled));
        this.saveValues(e);
        this.saveExecutions(e);
        this.saveChildren(e);
        this.saveProperties(e);
    }

    private void saveExecutions(HashMap<String, Object> e) {
        if (this.executions.size() == 0) {
            return;
        }
        ArrayList<HashMap<String, Object>> executions = new ArrayList<HashMap<String, Object>>();
        e.put("executions", executions);
        for (ExecutionImpl d : this.executions) {
            HashMap<String, Object> execution = new HashMap<String, Object>();
            executions.add(execution);
            d.toJson(execution);
        }
    }

    private void saveChildren(HashMap<String, Object> e) {
        if (this.children != null) {
            ArrayList<HashMap<String, Object>> children = new ArrayList<HashMap<String, Object>>(this.children.size());
            e.put("children", children);
            for (DataAreaImpl d : this.children) {
                HashMap<String, Object> mem = new HashMap<String, Object>();
                children.add(mem);
                d.toJson(mem);
            }
        }
    }

    private void saveValues(HashMap<String, Object> e) {
        ArrayList<Object> values = new ArrayList<Object>(this.values.length);
        e.put("values", values);
        for (int i = 0; i < this.values.length; ++i) {
            VariableImpl v = this.flow.getVariable(i);
            if (v.isTransient()) {
                values.add(null);
                continue;
            }
            DataType type = v.getType();
            values.add(type.forJson(this.values[i]));
        }
    }

    public DataAreaImpl(RuntimeImpl runtime) {
        this(runtime, runtime.getFlow(), null);
    }

    void add(ExecutionImpl e) {
        this.executions.add(e);
    }

    public DataAreaImpl(ExecutionImpl host, FlowImpl flow, int[] input_a, Object[] input_v) {
        this(host.getRuntime(), flow, host);
        for (int i = 0; i < input_a.length; ++i) {
            int v = input_a[i];
            this.values[v] = input_v[i];
        }
        this.parent = host.getMemory();
        if (this.parent.children == null) {
            this.parent.children = new ArrayList();
        }
        this.parent.children.add(this);
    }

    void remove(ExecutionImpl e) {
        this.executions.remove(e);
        if (this.executions.size() == 0 && !this.canceled) {
            this.output2parent();
            this.parent.children.remove(this);
            this.host = null;
        }
    }

    private void output2parent() {
        Output output = ((NodeImpl)this.getHost().getDefine()).getOutput();
        if (output != null) {
            output.output(this);
        }
    }

    public void setCanceled() {
        this.canceled = true;
    }

    public int getExecutionCount() {
        return this.executions.size();
    }

    @Override
    public RuntimeImpl getRuntime() {
        return this.runtime;
    }

    @Override
    public FlowImpl getFlow() {
        return this.flow;
    }

    private DataAreaImpl(RuntimeImpl runtime, FlowImpl flow, ExecutionImpl host) {
        this.host = host;
        this.flow = flow;
        this.runtime = runtime;
        this.id = String.valueOf(runtime.nextId());
        int count = flow.variableCount();
        this.values = new Object[count];
        for (int i = 0; i < count; ++i) {
            VariableImpl v = flow.getVariable(i);
            this.reset(v);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ExecutionImpl getHost() {
        if (this.host == null) {
            this.host = this.runtime.getRootExecution();
        }
        return this.host;
    }

    @Override
    public Object getAt(Variable v) {
        return this.innerGet((VariableImpl)v);
    }

    @Override
    public Object getAt(int address) {
        return this.values[address];
    }

    private Object innerGet(VariableImpl v) {
        return this.values[v.getAddress()];
    }

    void innerSetAt(VariableImpl v, Object value) {
        int address = v.getAddress();
        this.values[address] = v.getType().narrow(value);
    }

    public void clear(VariableImpl v) {
        this.values[v.getAddress()] = null;
    }

    public void reset(VariableImpl v) {
        this.clear(v);
        Object init = v.getInitValue();
        if (init != null) {
            if (!init.getClass().isArray()) {
                this.innerSetAt(v, init);
            } else {
                int len = Array.getLength(init);
                for (int i = 0; i < len; ++i) {
                    Object o = Array.get(init, i);
                    this.innerSetAt(v, o);
                }
            }
        }
    }

    private void fireEvent(VariableImpl v) {
        if (v.getCommandCount() > 0) {
            ExecutionImpl e = new ExecutionImpl(this.getHost(), v, this);
            this.runtime.pushAtFirst(e);
        }
    }

    public void setAt(VariableImpl v, Object value) {
        this.innerSetAt(v, value);
        this.fireEvent(v);
    }

    @Override
    public DataAreaImpl getParent() {
        return this.parent;
    }

    public List<DataAreaImpl> getChildren() {
        if (this.children != null) {
            return Collections.unmodifiableList(this.children);
        }
        return Consts.EMPTY_LIST;
    }

    public boolean hasSubDataAreas() {
        return this.children != null;
    }

    public String toString() {
        return this.id;
    }
}

