/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.isc.iscb.util.flow.core.PropertyContainer;

public class PropertyContainerImpl
implements PropertyContainer {
    private static final String VALUE = "value";
    private HashMap<String, Object> properties;
    private HashMap<String, Object> transientProperties;

    void restoreProperties(Map<String, Object> e) {
        List properties = (List)e.get("properties");
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.properties = new HashMap(properties.size() << 1);
        for (Map property : properties) {
            String key = (String)property.get("key");
            String type = (String)property.get("type");
            if (type == null) {
                this.properties.put(key, property.get(VALUE));
                continue;
            }
            if ("collection".equals(type)) {
                this.properties.put(key, property.get(VALUE));
                continue;
            }
            if ("set".equals(type)) {
                Collection value = (Collection)property.get(VALUE);
                LinkedHashSet list = new LinkedHashSet(value.size());
                list.addAll(value);
                this.properties.put(key, list);
                continue;
            }
            if ("map".equals(type)) {
                this.properties.put(key, property.get(VALUE));
                continue;
            }
            if ("array".equals(type)) {
                Collection c = (Collection)property.get(VALUE);
                String[] values = c.toArray(new String[c.size()]);
                this.properties.put(key, values);
                continue;
            }
            throw new UnsupportedOperationException("Type '" + type + "' not supported!");
        }
    }

    void saveProperties(HashMap<String, Object> data) {
        if (this.properties == null) {
            return;
        }
        ArrayList properties = new ArrayList(this.properties.size());
        data.put("properties", properties);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            properties.add(item);
            item.put("key", entry.getKey());
            Object v = entry.getValue();
            item.put(VALUE, v);
            if (v instanceof Set) {
                item.put("type", "set");
                continue;
            }
            if (v instanceof Collection) {
                item.put("type", "collection");
                continue;
            }
            if (v instanceof Map) {
                item.put("type", "map");
                continue;
            }
            if (!(v instanceof String[])) continue;
            item.put("type", "array");
        }
    }

    @Override
    public final Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public boolean hasProperty(String name) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(name);
    }

    @Override
    public void clearProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    @Override
    public final void setProperty(String name, Object value) {
        if (value == null) {
            this.clearProperty(name);
            return;
        }
        this.initProperties();
        this.properties.put(name, value);
    }

    private void initProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
    }

    @Override
    public Map<String, ?> getProperties() {
        if (this.properties == null) {
            return new HashMap(1);
        }
        return (Map)this.properties.clone();
    }

    @Override
    public synchronized Object getTransientProperty(String name) {
        if (this.transientProperties == null) {
            return null;
        }
        return this.transientProperties.get(name);
    }

    @Override
    public synchronized void setTransientProperty(String name, Object value) {
        if (this.transientProperties == null) {
            this.transientProperties = new HashMap();
        }
        this.transientProperties.put(name, value);
    }
}

