/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.script.misc.Const;

public interface LockFactory {
    public static final Const<LockFactory> INSTANCE = new Const<1>(new LockFactory(){
        private ConcurrentHashMap<String, Lock> locks = new ConcurrentHashMap();

        @Override
        public Lock getLock(String key) {
            Lock lock = this.locks.get(key);
            if (lock != null) {
                return lock;
            }
            this.locks.putIfAbsent(key, this.createLock());
            return this.locks.get(key);
        }

        private Lock createLock() {
            return new Lock(){
                private ReentrantLock ins = new ReentrantLock();

                @Override
                public boolean tryLock(int timeout) {
                    try {
                        return this.ins.tryLock(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw CommonError.THREAD_INTERRUPTED.wrap(e);
                    }
                }

                @Override
                public void unLock() {
                    this.ins.unlock();
                }

                @Override
                public void close() {
                }
            };
        }
    });

    public Lock getLock(String var1);

    public static interface Lock {
        public boolean tryLock(int var1);

        public void unLock();

        public void close();
    }
}

