/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc;

import java.lang.reflect.Constructor;
import java.text.Normalizer;
import java.util.HashSet;
import kd.isc.iscb.util.err.CommonError;

public class ReflectionUtil {
    public static Class<?> getClass(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String name = Normalizer.normalize(className, Normalizer.Form.NFC);
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw CommonError.CLASS_NOT_FOUND.create(e, className);
        }
    }

    public static Object newInstance(Class<?> c) {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw CommonError.INSTANTIATION_FAILURE.create(e, c.getName());
        }
        catch (IllegalAccessException e) {
            throw CommonError.INSTANTIATION_FAILURE.create(e, c.getName());
        }
    }

    public static Object newInstance(String className) {
        Class<?> c = ReflectionUtil.getClass(className);
        return ReflectionUtil.newInstance(c);
    }

    public static Object newInstance(String className, Class<?>[] types, Object[] params) {
        Class<?> c = ReflectionUtil.getClass(className);
        return ReflectionUtil.newInstance(c, types, params);
    }

    public static Object newInstance(Class<?> c, Class<?>[] types, Object[] params) {
        try {
            Constructor<?> constructor = c.getConstructor(types);
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw CommonError.INSTANTIATION_FAILURE.create(e, c.getName());
        }
    }

    public static Class<?>[] getInterfaces(Object impl) {
        HashSet interfaces = new HashSet(16);
        for (Class<?> c = impl.getClass(); c != null; c = c.getSuperclass()) {
            for (Class<?> i : c.getInterfaces()) {
                interfaces.add(i);
            }
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }
}

