/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc.mem.c;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.isc.iscb.util.misc.mem.ClassSizeInfo;
import kd.isc.iscb.util.misc.mem.ObjectSizeCalculator;
import kd.isc.iscb.util.misc.mem.c.DefaultClassSizeInfo;

public class BigDecimalClassSizeInfo
implements ClassSizeInfo {
    private final long selfFixedObjectSize = new DefaultClassSizeInfo(BigDecimal.class).getObjectSize();
    private final long bigIntFixedObjectSize = new DefaultClassSizeInfo(BigInteger.class).getObjectSize();

    @Override
    public void visit(Object obj, ObjectSizeCalculator calc, int level) {
        int p = ((BigDecimal)obj).precision();
        if (p <= 18) {
            calc.increaseSize(this.selfFixedObjectSize);
        } else {
            int bytes = (int)((double)p * 3.3219281) + 7 >>> 3;
            long intArraySize = ObjectSizeCalculator.roundTo(ObjectSizeCalculator.ARRAY_HEADER_SIZE + bytes, ObjectSizeCalculator.OBJECT_PADDING);
            calc.increaseSize(this.selfFixedObjectSize + this.bigIntFixedObjectSize + intArraySize);
        }
    }

    @Override
    public Class<?> forClass() {
        return BigDecimal.class;
    }
}

