/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc.mem.c;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import kd.isc.iscb.util.misc.mem.ClassSizeInfo;
import kd.isc.iscb.util.misc.mem.ObjectSizeCalculator;

public class DefaultClassSizeInfo
implements ClassSizeInfo {
    private final long objectSize;
    private final long fieldsSize;
    private final Field[] referenceFields;
    private final Class<?> clazz;

    public DefaultClassSizeInfo(Class<?> clazz) {
        long newFieldsSize = 0L;
        LinkedList<Field> newReferenceFields = new LinkedList<Field>();
        for (Field f : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            Class<?> type = f.getType();
            if (type.isPrimitive()) {
                newFieldsSize += ObjectSizeCalculator.getPrimitiveFieldSize(type);
                continue;
            }
            f.setAccessible(true);
            newReferenceFields.add(f);
            newFieldsSize += (long)ObjectSizeCalculator.REFERENCE_SIZE;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            DefaultClassSizeInfo superClassInfo = new DefaultClassSizeInfo(superClass);
            newFieldsSize += ObjectSizeCalculator.roundTo(superClassInfo.fieldsSize, ObjectSizeCalculator.SUPERCLASS_FIELD_PADDING);
            newReferenceFields.addAll(Arrays.asList(superClassInfo.referenceFields));
        }
        this.clazz = clazz;
        this.fieldsSize = newFieldsSize;
        this.objectSize = ObjectSizeCalculator.roundTo((long)ObjectSizeCalculator.OBJECT_HEADER_SIZE + newFieldsSize, ObjectSizeCalculator.OBJECT_PADDING);
        this.referenceFields = newReferenceFields.toArray(new Field[newReferenceFields.size()]);
    }

    @Override
    public Class<?> forClass() {
        return this.clazz;
    }

    public long getObjectSize() {
        return this.objectSize;
    }

    public long getFieldsSize() {
        return this.fieldsSize;
    }

    @Override
    public void visit(Object obj, ObjectSizeCalculator calc, int level) {
        if (calc.addVisited(obj)) {
            calc.increaseSize(this.objectSize);
            this.visitComponents(obj, calc, level + 1);
        }
    }

    private void visitComponents(Object obj, ObjectSizeCalculator calc, int level) {
        calc.checkLevel(level);
        for (Field f : this.referenceFields) {
            try {
                Object value = f.get(obj);
                if (value == null) continue;
                calc.visit(value, level);
            }
            catch (Throwable e) {
                AssertionError ae = new AssertionError((Object)("Unexpected denial of access to " + f));
                ((Throwable)((Object)ae)).initCause(e);
                throw ae;
            }
        }
    }
}

