/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc.mem.c;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.misc.mem.ClassSizeInfo;
import kd.isc.iscb.util.misc.mem.ObjectSizeCalculator;
import kd.isc.iscb.util.misc.mem.c.DefaultClassSizeInfo;

public class MapClassSizeInfo
implements ClassSizeInfo {
    private final long fixedObjectSize;
    private final long elementExtObjectSize;
    private final Class<?> clazz;

    public MapClassSizeInfo(Class<?> clazz) {
        if (!Map.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7c7b\uff08%s\uff09\u4e0d\u662fMap\u7c7b\u578b\u3002", (String)"MapClassSizeInfo_2", (String)"isc-iscb-util", (Object[])new Object[0]), clazz.getName()));
        }
        this.clazz = clazz;
        this.fixedObjectSize = new DefaultClassSizeInfo(clazz).getObjectSize();
        this.elementExtObjectSize = this.getElementExtObjectSize(clazz);
    }

    @Override
    public Class<?> forClass() {
        return this.clazz;
    }

    @Override
    public void visit(Object obj, ObjectSizeCalculator calc, int level) {
        Map m = (Map)obj;
        int length = m.size();
        if (length == 0) {
            calc.increaseSize(this.fixedObjectSize);
        } else {
            long objectSize = (long)length * this.elementExtObjectSize + this.fixedObjectSize;
            calc.increaseSize(objectSize);
            this.visitComponents(m, calc, level + 1);
        }
    }

    private void visitComponents(Map<?, ?> m, ObjectSizeCalculator calc, int level) {
        calc.checkLevel(level);
        for (Map.Entry<?, ?> e : m.entrySet()) {
            calc.visit(e.getKey(), level);
            calc.visit(e.getValue(), level);
        }
    }

    private long getElementExtObjectSize(Class<?> clazz) {
        if (LinkedHashMap.class.isAssignableFrom(clazz)) {
            return (long)(ObjectSizeCalculator.OBJECT_HEADER_SIZE * 2 + ObjectSizeCalculator.REFERENCE_SIZE * 5) + ObjectSizeCalculator.getPrimitiveFieldSize(Integer.TYPE);
        }
        if (TreeMap.class.isAssignableFrom(clazz)) {
            return (long)(ObjectSizeCalculator.OBJECT_HEADER_SIZE * 2 + ObjectSizeCalculator.REFERENCE_SIZE * 5) + ObjectSizeCalculator.getPrimitiveFieldSize(Boolean.TYPE);
        }
        return (long)(ObjectSizeCalculator.OBJECT_HEADER_SIZE * 2 + ObjectSizeCalculator.REFERENCE_SIZE * 3) + ObjectSizeCalculator.getPrimitiveFieldSize(Integer.TYPE);
    }
}

