/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;
import kd.isc.iscb.util.script.LifeScriptContext;
import kd.isc.iscb.util.script.core.Analyzer;
import kd.isc.iscb.util.script.core.Feature;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.PropertyAccessor;
import kd.isc.iscb.util.script.core.StatementBuilder;
import kd.isc.iscb.util.script.core.StatementEnd;
import kd.isc.iscb.util.script.core.Style;
import kd.isc.iscb.util.script.core.ToolKit;
import kd.isc.iscb.util.script.parser.Program;
import kd.isc.iscb.util.script.parser.ScriptParser;

public class LifeScriptEngine
implements Compilable,
ScriptEngine,
ObjectSizeIgnored {
    private List<Analyzer> analyzers = new ArrayList<Analyzer>();
    private Map<Identifier, Object> builders = new HashMap<Identifier, Object>();
    private ScriptEngineFactory factory;
    private Style style;
    private Map<String, Object> elements = new HashMap<String, Object>();
    private static volatile long now;
    private static final ReadLockFreeMap<Class<?>, PropertyAccessor> accessors;

    public LifeScriptEngine(ScriptEngineFactory factory, Style style, Feature ... features) {
        this.factory = factory;
        this.style = style;
        style.apply(this);
        for (Feature f : features) {
            f.apply(this);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        StringReader reader = this.newReader(script);
        return this.eval((Reader)reader, context);
    }

    private StringReader newReader(String script) {
        if (script == null) {
            return new StringReader("");
        }
        return new StringReader(script);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.compile(reader).eval(context);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Program compile(String script) {
        script = this.style.preprocess(script);
        StringReader reader = this.newReader(script);
        try {
            return this.compile(reader);
        }
        catch (ScriptException e) {
            throw CommonError.SCRIPT_GRAMMAR_ERROR.create(e, e.getMessage(), script);
        }
    }

    public Program compile(String script, Map<String, Object> context) {
        return this.compile(script, null, context);
    }

    public Program compile(String script, String resId, Map<String, Object> context) {
        script = this.style.preprocess(script);
        StringReader reader = this.newReader(script);
        try {
            return new ScriptParser(this, reader, resId, context).parse();
        }
        catch (ScriptException e) {
            throw CommonError.SCRIPT_GRAMMAR_ERROR.create(e, e.getMessage(), script);
        }
    }

    public void register(ToolKit toolkit) {
        this.register(toolkit.name(), (Object)toolkit);
        toolkit.registerOtherElements(this);
    }

    public boolean register(Analyzer analyzer) {
        Analyzer a;
        int i;
        if (this.analyzers.contains(analyzer)) {
            return false;
        }
        this.analyzers.add(null);
        for (i = this.analyzers.size(); i > 0 && (a = this.analyzers.get(i - 1)).priority() > analyzer.priority(); --i) {
            this.analyzers.set(i, a);
        }
        this.analyzers.set(i, analyzer);
        return true;
    }

    public void register(Identifier id) {
        this.register(id.name(), (Object)id);
    }

    public void register(String name, Object value) {
        Object o = this.elements.get(name);
        if (o != null) {
            throw new IscBizException(name + " is registered for " + o + ".");
        }
        this.elements.put(name, value);
    }

    public void replace(Identifier id) {
        this.elements.put(id.name(), id);
    }

    public void register(Identifier id, Object builder) {
        this.register(id);
        this.builders.put(id, builder);
    }

    public Object getBuilder(Identifier id) {
        return this.builders.get(id);
    }

    public int getAnalyzerCount() {
        return this.analyzers.size();
    }

    public Analyzer getAnalyzer(int index) {
        return this.analyzers.get(index);
    }

    public Style getStyle() {
        return this.style;
    }

    public StatementEnd getStatementEnd() {
        return this.style.defaultTerminator();
    }

    public StatementBuilder getStatementBuilder() {
        return (StatementBuilder)this.getBuilder(this.getStatementEnd());
    }

    @Override
    public Program compile(Reader reader) throws ScriptException {
        return this.compile(reader, new HashMap<String, Object>());
    }

    public Program compile(Reader reader, Map<String, Object> context) throws ScriptException {
        ScriptParser parser = new ScriptParser(this, reader, context);
        return parser.parse();
    }

    public Object parseJson(String json) throws ScriptException {
        StringReader reader = this.newReader(json);
        return this.parseJson(reader);
    }

    public Object parseJson(Reader reader) {
        ScriptParser parser = new ScriptParser(this, reader, new HashMap<String, Object>());
        try {
            return parser.parseJson();
        }
        catch (ScriptException e) {
            throw CommonError.SCRIPT_GRAMMAR_ERRORX.wrap(e);
        }
    }

    public Object parseOnly(Reader reader, Map<String, Object> ctx) throws ScriptException {
        ScriptParser parser = new ScriptParser(this, reader, ctx);
        return parser.parseOnly();
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(this.newReader(script));
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, (ScriptContext)this.getContext());
    }

    @Override
    public Object eval(String script, Bindings n) throws ScriptException {
        return this.eval((Reader)this.newReader(script), n);
    }

    @Override
    public Object eval(Reader reader, Bindings n) throws ScriptException {
        return this.eval(reader, (ScriptContext)this.getContext());
    }

    @Override
    public Object get(String key) {
        return this.elements.get(key);
    }

    @Override
    public void put(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContext(ScriptContext ctxt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bindings getBindings(int scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LifeScriptContext getContext() {
        return new LifeScriptContext();
    }

    public static long getNow() {
        return now;
    }

    public static void setNow() {
        now = System.currentTimeMillis();
    }

    public static void register(PropertyAccessor accessor) {
        accessors.put(accessor.targetClass(), accessor);
    }

    public static PropertyAccessor getPropertyAccessor(Class<?> targetClass) {
        return accessors.get(targetClass);
    }

    static {
        accessors = new ReadLockFreeMap();
    }
}

