/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.accessor;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.accessor.NameAccessorImpl;
import kd.isc.iscb.util.script.analyzer.expr.ListConstructor;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.core.Accessor;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.PropertyAccessor;
import kd.isc.iscb.util.script.core.Repository;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.ToolKit;
import kd.isc.iscb.util.script.data.Tuple;

final class IndexAccessorImpl
implements Accessor {
    private Object stub;
    private Object index;
    private Statement smt;

    public String toString() {
        return this.stub + "[" + this.index + "]";
    }

    IndexAccessorImpl(Object stub, ListConstructor index, Statement smt) {
        this.stub = stub;
        this.index = index.get(0);
        this.smt = smt;
    }

    @Override
    public Object set(ScriptContext ctx, Object value) {
        Object stub0 = IndexAccessorImpl.eval(ctx, this.stub);
        if (stub0 == null) {
            throw new NullPointerException(this.stub.toString());
        }
        Object index0 = IndexAccessorImpl.eval(ctx, this.index);
        return IndexAccessorImpl.set(stub0, index0, value);
    }

    private static Object eval(ScriptContext ctx, Object def) {
        Object value = Util.eval(ctx, def);
        return value;
    }

    @Override
    public Object eval(ScriptContext ctx) {
        Object value = IndexAccessorImpl.eval(ctx, this.stub);
        if (value == null) {
            throw new NullPointerException("\"" + this.stub + "[" + this.index + "]\"");
        }
        Object index = IndexAccessorImpl.eval(ctx, this.index);
        if (index == null) {
            return null;
        }
        return IndexAccessorImpl.call(ctx, this.stub, value, index, this.smt);
    }

    private static Object call(ScriptContext ctx, Object stub, Object value, Object index, Statement smt) {
        if (value instanceof List) {
            if (index instanceof Number) {
                return IndexAccessorImpl.getElementFromList((List)value, index);
            }
            return NameAccessorImpl.getColumnFromList(stub, index.toString(), (Collection)value, false, smt.line());
        }
        if (index instanceof Number) {
            int i = ((Number)index).intValue();
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                return i >= 0 && i < array.length ? array[i] : null;
            }
            if (value instanceof CharSequence) {
                return Character.valueOf(((CharSequence)value).charAt(i));
            }
            if (value instanceof Tuple) {
                return ((Tuple)value).get(i);
            }
            if (value.getClass().isArray()) {
                return Array.get(value, i);
            }
        }
        if (value instanceof Context) {
            return ((Context)value).get(index.toString());
        }
        if (value instanceof Map) {
            return ((Map)value).get(index);
        }
        if (value instanceof Repository) {
            return ((Repository)value).get(index);
        }
        if (value instanceof ToolKit) {
            Identifier tool = ((ToolKit)value).get(index.toString());
            return Util.eval(ctx, tool);
        }
        if (value instanceof Collection) {
            return NameAccessorImpl.getColumnFromList(stub, index.toString(), (Collection)value, false, smt.line());
        }
        PropertyAccessor accessor = LifeScriptEngine.getPropertyAccessor(value.getClass());
        if (accessor != null) {
            return accessor.get(value, index.toString());
        }
        throw new UnsupportedOperationException("\"" + stub + "[" + index + "]\", " + value.getClass().getName());
    }

    private static Object getElementFromList(List<?> list, Object index) {
        int i = ((Number)index).intValue();
        return i >= 0 && i < list.size() ? list.get(i) : null;
    }

    private static boolean set(Object stub, Object index, Object value) {
        if (stub instanceof List) {
            IndexAccessorImpl.setList((List)stub, ((Number)index).intValue(), value);
            return true;
        }
        if (stub instanceof Context) {
            return ((Context)stub).set((String)index, value);
        }
        if (stub instanceof Map) {
            return ((Map)stub).put(index, value) != null;
        }
        if (stub instanceof Object[]) {
            ((Object[])stub)[((Number)index).intValue()] = value;
            return true;
        }
        if (stub instanceof Repository) {
            return ((Repository)stub).set(index, value);
        }
        throw new UnsupportedOperationException();
    }

    private static void setList(List<Object> list, int index, Object value) {
        if (index < list.size()) {
            list.set(index, value);
        } else if (index == list.size()) {
            list.add(value);
        } else {
            while (index > list.size()) {
                list.add(null);
            }
            list.add(value);
        }
    }
}

